"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var MatchingWordController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchingWordController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const domain_1 = require("../../../domain");
let MatchingWordController = MatchingWordController_1 = class MatchingWordController {
    constructor(matchingWordService) {
        this.matchingWordService = matchingWordService;
        this.LOGGER = new framework_1.PrimeLogger(MatchingWordController_1.name);
    }
    async save(data) {
        this.LOGGER.log(`Saving new matching word: ${data}`);
        await this.matchingWordService.save(data);
        return 'true';
    }
    async update(data) {
        this.LOGGER.log(`Updating matching word: ${data}`);
        await this.matchingWordService.update(data);
        return 'true';
    }
    async findAll() {
        this.LOGGER.log('Finding all matching words');
        return await this.matchingWordService.findAll();
    }
    async getPaginatedUserCampaign(page, pageSize, subdivisionId, wordSearch) {
        this.LOGGER.log(`getPaginatedUserCampaign - page: ${page}, pageSize: ${pageSize}, subdivisionId: ${subdivisionId} wordSearch: ${wordSearch}`);
        return await this.matchingWordService.getPagination(page, pageSize, subdivisionId, wordSearch ? wordSearch : '');
    }
    async erraseAccount(id) {
        this.LOGGER.log(`erraseAccount user ${id}`);
        await this.matchingWordService.delete(id);
        return 'true';
    }
};
exports.MatchingWordController = MatchingWordController;
__decorate([
    (0, common_1.Post)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, swagger_1.ApiBody)({ type: domain_1.InsertMatchingWord }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.InsertMatchingWord]),
    __metadata("design:returntype", Promise)
], MatchingWordController.prototype, "save", null);
__decorate([
    (0, common_1.Put)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, swagger_1.ApiBody)({ type: domain_1.UpdateMatchingWord }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.UpdateMatchingWord]),
    __metadata("design:returntype", Promise)
], MatchingWordController.prototype, "update", null);
__decorate([
    (0, common_1.Get)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.MatchingWord] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MatchingWordController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.MatchingWord] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiQuery)({ name: 'subdivisionId', required: true, type: String, description: 'Filtro para titulos' }),
    (0, swagger_1.ApiQuery)({ name: 'wordSearch', required: false, type: String, description: 'Filtro para titulos' }),
    __param(0, (0, common_1.Param)('page')),
    __param(1, (0, common_1.Param)('pageSize')),
    __param(2, (0, common_1.Query)('subdivisionId')),
    __param(3, (0, common_1.Query)('wordSearch')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], MatchingWordController.prototype, "getPaginatedUserCampaign", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiConflictResponse)({ type: framework_1.ApiErrorResponse }),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], MatchingWordController.prototype, "erraseAccount", null);
exports.MatchingWordController = MatchingWordController = MatchingWordController_1 = __decorate([
    (0, common_1.Controller)('matching-word'),
    (0, swagger_1.ApiTags)('matching-word'),
    __param(0, (0, common_1.Inject)('MatchingWordService')),
    __metadata("design:paramtypes", [Object])
], MatchingWordController);
//# sourceMappingURL=matching_word.controller.js.map