import { TxType } from 'src/framework';
import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { CompanyKeywordRepository } from 'src/licitaapp/application/repository/company-keyword-repository/company-keyword-repository.interface';
import { Keyword } from 'src/licitaapp/domain';
export declare class CompanyKeywordRepositoryImpl implements CompanyKeywordRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    findByCompanyId(companyId: number, tx?: TxType): Promise<Keyword[]>;
    deleteByCompanyAndKeywordId(companyId: number, keywordId: number, tx?: TxType): Promise<void>;
    deleteByCompanyId(companyId: number, tx?: TxType): Promise<void>;
    saveAll(companyId: number, keywordId: number[], tx?: TxType): Promise<void>;
}
