"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var CompanyKeywordRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyKeywordRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
let CompanyKeywordRepositoryImpl = CompanyKeywordRepositoryImpl_1 = class CompanyKeywordRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(CompanyKeywordRepositoryImpl_1.name);
    }
    async findByCompanyId(companyId, tx) {
        this.LOGGER.log(`findByCompanyId companyId: ${companyId}`);
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.keywordTable.id,
            value: framework_1.schema.keywordTable.value,
            origin: framework_1.schema.keywordTable.origin,
            metadata: framework_1.schema.keywordTable.metadata,
            codeCategoriaMercadoPublico: framework_1.schema.keywordTable.codeCategoriaMercadoPublico,
        })
            .from(framework_1.schema.keywordTable)
            .leftJoin(framework_1.schema.companyKeywordTable, (0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.id, framework_1.schema.companyKeywordTable.keywordId))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.companyKeywordTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.active, true)))
            .then((rows) => {
            return rows.map((row) => new domain_1.Keyword(row.id, row.value, row.codeCategoriaMercadoPublico, row.origin, undefined, row.metadata));
        });
    }
    deleteByCompanyAndKeywordId(companyId, keywordId, tx) {
        this.LOGGER.log(`deleteByCompanyAndKeywordId companyId: ${companyId} keywordId: ${keywordId}`);
        (tx || this.db.conn)
            .delete(framework_1.schema.companyKeywordTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.companyKeywordTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.companyKeywordTable.keywordId, keywordId))).execute();
        return Promise.resolve();
    }
    async deleteByCompanyId(companyId, tx) {
        this.LOGGER.log(`deleteByCompanyId keyword: ${companyId}`);
        await (tx || this.db.conn)
            .delete(framework_1.schema.companyKeywordTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.companyKeywordTable.companyId, companyId));
    }
    async saveAll(companyId, keywordId, tx) {
        this.LOGGER.log(`saveAll companyId: ${companyId} keywordId: ${keywordId}`);
        for (const keywordIdItem of keywordId) {
            try {
                const validated = framework_1.schema.companyKeywordTableInsertSchema.parse({
                    companyId: +companyId,
                    keywordId: +keywordIdItem
                });
                await (tx || this.db.conn)
                    .insert(framework_1.schema.companyKeywordTable)
                    .values(validated);
            }
            catch (error) {
                if (error.code === '23505' || error.message?.includes('duplicate')) {
                    this.LOGGER.warn(`Duplicate key ignored for companyId: ${companyId}, keywordId: ${keywordIdItem}`);
                }
                else {
                    this.LOGGER.error(`Error inserting companyId: ${companyId}, keywordId: ${keywordIdItem}`, error);
                    throw error;
                }
            }
        }
    }
};
exports.CompanyKeywordRepositoryImpl = CompanyKeywordRepositoryImpl;
exports.CompanyKeywordRepositoryImpl = CompanyKeywordRepositoryImpl = CompanyKeywordRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], CompanyKeywordRepositoryImpl);
//# sourceMappingURL=company-keyword-repository-impl.js.map