import { TxType } from 'src/framework';
import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { CompanyRepository } from 'src/licitaapp/application';
import { CompanyRegisterTO, Company, InsertCompany } from 'src/licitaapp/domain';
import { CompanyUserTO, PaginationKeywordTO } from 'src/licitaapp/domain/dto/company.user.to';
import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';
export declare class CompanyRepositoryImpl implements CompanyRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    paginationByCompanyKeyword(page: number, pageSize: number, socialReason?: string): Promise<PaginationKeywordTO[]>;
    getAllCompanyWithoutKeywords(): Promise<number[]>;
    getCompanyIdsActive(): Promise<number[]>;
    updateCheckTenders(companyId: number, checkTender: boolean, tx?: TxType): Promise<boolean>;
    update(companyId: number, companyData: CompanyRegisterTO, tx?: TxType): Promise<boolean>;
    save(company: InsertCompany, tx?: TxType): Promise<Company>;
    saveCompanySubdivisions(companyId: number, listSubdivisions: Subdivision[], tx?: TxType): Promise<void>;
    findCompaniesSubdivisions(companyId: number, tx?: TxType): Promise<Subdivision[]>;
    deletedCompanySubdivisions(companyId: number, tx?: TxType): Promise<void>;
    findByDNI(dni: string, tx?: TxType): Promise<Company | null>;
    findById(id: number, tx?: TxType): Promise<Company | null>;
    getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
    getCompanyIdsToRecalculateTender(): Promise<number[]>;
    paginationByCompanyAdmin(page: number, pageSize: number): Promise<CompanyUserTO[]>;
}
