"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var CompanyRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const framework_2 = require("../../../../framework");
const util_1 = require("util");
const drizzle_orm_1 = require("drizzle-orm");
const company_user_to_1 = require("../../../domain/dto/company.user.to");
const util_2 = require("../../../domain/util");
const subdivision_entity_1 = require("../../../../framework/domain/entities/subdivision.entity");
let CompanyRepositoryImpl = CompanyRepositoryImpl_1 = class CompanyRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(CompanyRepositoryImpl_1.name);
    }
    async paginationByCompanyKeyword(page, pageSize, socialReason) {
        this.LOGGER.log(`pagination admin page ${page} pageSize ${pageSize}`);
        const offset = (page - 1) * pageSize;
        const baseQuery = this.db.conn
            .select({
            companyId: framework_2.schema.companyTable.id,
            dni: framework_2.schema.companyTable.dni,
            socialReason: framework_2.schema.companyTable.socialReason,
            active: framework_2.schema.companyTable.active,
        })
            .from(framework_2.schema.companyTable);
        const query = socialReason
            ? baseQuery.where((0, drizzle_orm_1.like)(framework_2.schema.companyTable.socialReason, '%' + socialReason + '%'))
            : baseQuery;
        return await query
            .offset(offset)
            .limit(Number(pageSize))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                const company = new company_user_to_1.PaginationKeywordTO();
                company.companyId = row.companyId;
                company.dni = row.dni;
                company.active = row.active;
                company.socialReason = row.socialReason;
                company.amountTenders = 0;
                company.amountAgileTenders = 0;
                return company;
            });
        });
    }
    async getAllCompanyWithoutKeywords() {
        this.LOGGER.log('Getting all company without keywords');
        var outputList = [];
        await this.db.conn.execute(`SELECT c.id AS company_id, COUNT(k.id) AS total_keywords FROM company c JOIN keyword k ON k.company_id = c.id WHERE c.active = true and k.active = true GROUP BY c.id HAVING COUNT(k.id) = 1`).then((rows) => {
            const items = rows[0];
            outputList = items.map((item) => {
                return item.company_id;
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error getting companies without keywords: ${(0, util_1.inspect)(err)}`);
            throw err;
        });
        return outputList;
    }
    async getCompanyIdsActive() {
        this.LOGGER.log(`getCompanyIdsToRecalculateTender`);
        return await this.db.conn
            .select({
            id: framework_2.schema.companyTable.id,
        })
            .from(framework_2.schema.companyTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_2.schema.companyTable.active, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => row.id);
        });
    }
    async updateCheckTenders(companyId, checkTender, tx) {
        this.LOGGER.log(`updateCheckTenders: ${companyId}`);
        await (tx || this.db.conn)
            .update(framework_2.schema.companyTable)
            .set({
            updatedAt: util_2.TenderUtil.getCurrentSystemDate(),
            checkTender: checkTender,
        })
            .where((0, drizzle_orm_1.eq)(framework_2.schema.companyTable.id, companyId))
            .execute();
        return true;
    }
    async update(companyId, companyData, tx) {
        this.LOGGER.log(`update repository: ${companyId}`);
        const validatedCompany = framework_2.schema.companyTableUpdateSchema.parse({
            dni: companyData.company.dni,
            socialReason: companyData.company.socialReason,
            updatedAt: util_2.TenderUtil.getCurrentSystemDate(),
            checkTender: true,
        });
        await (tx || this.db.conn)
            .update(framework_2.schema.companyTable)
            .set(validatedCompany)
            .where((0, drizzle_orm_1.eq)(framework_2.schema.companyTable.id, companyId))
            .execute();
        return true;
    }
    async save(company, tx) {
        this.LOGGER.log(`save repository: ${(0, util_1.inspect)(company)}`);
        const companyFound = await this.findByDNI(company.dni, tx);
        if (companyFound) {
            this.LOGGER.log(`Company found with id: ${companyFound.id}`);
            return companyFound;
        }
        const validatedCompany = framework_2.schema.companyTableInsertSchema.parse({
            dni: company.dni,
            socialReason: company.socialReason,
        });
        const insertedCompanyId = await (tx || this.db.conn)
            .insert(framework_2.schema.companyTable)
            .values(validatedCompany)
            .$returningId()
            .then((rows) => {
            return rows[0].id;
        });
        return await this.findById(insertedCompanyId, tx).then((dataObject) => {
            if (dataObject) {
                return dataObject;
            }
            else {
                throw new Error('Company not found');
            }
        });
    }
    async saveCompanySubdivisions(companyId, listSubdivisions, tx) {
        listSubdivisions = listSubdivisions.filter((subdivision) => subdivision.id !== 7777);
        this.LOGGER.log(`saveCompanySubdivisions repository: ${companyId}`);
        await (tx || this.db.conn)
            .insert(framework_2.schema.companySubdivisionTable)
            .values(listSubdivisions.map((subdivision) => {
            return {
                companyId,
                subdivisionId: subdivision.id,
            };
        }))
            .execute();
    }
    async findCompaniesSubdivisions(companyId, tx) {
        this.LOGGER.log(`findCompaniesSubdivisions repository: ${companyId}`);
        return await (tx || this.db.conn)
            .select({
            id: framework_2.schema.subdivisionTable.id,
            name: framework_2.schema.subdivisionTable.name,
            code: framework_2.schema.subdivisionTable.code,
        })
            .from(framework_2.schema.companySubdivisionTable)
            .innerJoin(framework_2.schema.subdivisionTable, (0, drizzle_orm_1.eq)(framework_2.schema.companySubdivisionTable.subdivisionId, framework_2.schema.subdivisionTable.id))
            .where((0, drizzle_orm_1.eq)(framework_2.schema.companySubdivisionTable.companyId, companyId))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => new subdivision_entity_1.Subdivision(row.id, row.name, row.code));
        });
    }
    async deletedCompanySubdivisions(companyId, tx) {
        this.LOGGER.log(`deletedCompanySubdivisions repository: ${companyId}`);
        await (tx || this.db.conn)
            .delete(framework_2.schema.companySubdivisionTable)
            .where((0, drizzle_orm_1.eq)(framework_2.schema.companySubdivisionTable.companyId, companyId))
            .execute();
    }
    async findByDNI(dni, tx) {
        this.LOGGER.log(`findByDNI repository: ${dni}`);
        return await (tx || this.db.conn)
            .select({
            id: framework_2.schema.companyTable.id,
            dni: framework_2.schema.companyTable.dni,
            socialReason: framework_2.schema.companyTable.socialReason,
        })
            .from(framework_2.schema.companyTable)
            .where((0, drizzle_orm_1.eq)(framework_2.schema.companyTable.dni, dni))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            return new domain_1.Company(rows[0].id, rows[0].dni, rows[0].socialReason);
        });
    }
    async findById(id, tx) {
        this.LOGGER.log(`findById repository: ${id}`);
        return await (tx || this.db.conn)
            .select({
            id: framework_2.schema.companyTable.id,
            dni: framework_2.schema.companyTable.dni,
            socialReason: framework_2.schema.companyTable.socialReason,
        })
            .from(framework_2.schema.companyTable)
            .where((0, drizzle_orm_1.eq)(framework_2.schema.companyTable.id, id))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            return new domain_1.Company(rows[0].id, rows[0].dni, rows[0].socialReason);
        });
    }
    async getSubdivisionsByCompanyId(companyId) {
        this.LOGGER.log(`getSubdivisionsByCompanyId repository: ${companyId}`);
        return await this.db.conn
            .select({
            id: framework_2.schema.subdivisionTable.id,
            name: framework_2.schema.subdivisionTable.name,
            code: framework_2.schema.subdivisionTable.code,
        })
            .from(framework_2.schema.companySubdivisionTable)
            .innerJoin(framework_2.schema.subdivisionTable, (0, drizzle_orm_1.eq)(framework_2.schema.companySubdivisionTable.subdivisionId, framework_2.schema.subdivisionTable.id))
            .where((0, drizzle_orm_1.eq)(framework_2.schema.companySubdivisionTable.companyId, companyId))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => new subdivision_entity_1.Subdivision(row.id, row.code, row.name));
        });
    }
    async getCompanyIdsToRecalculateTender() {
        this.LOGGER.log(`getCompanyIdsToRecalculateTender`);
        return await this.db.conn
            .select({
            id: framework_2.schema.companyTable.id,
        })
            .from(framework_2.schema.companyTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_2.schema.companyTable.active, true), (0, drizzle_orm_1.eq)(framework_2.schema.companyTable.checkTender, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => row.id);
        });
    }
    async paginationByCompanyAdmin(page, pageSize) {
        this.LOGGER.log(`pagination admin page ${page} pageSize ${pageSize}`);
        const offset = (page - 1) * pageSize;
        return await this.db.conn.
            select({
            companyId: framework_2.schema.companyTable.id,
            dni: framework_2.schema.companyTable.dni,
            socialReason: framework_2.schema.companyTable.socialReason,
            active: framework_2.schema.companyTable.active,
        })
            .from(framework_2.schema.companyTable)
            .orderBy(framework_2.schema.companyTable.dni)
            .offset(offset)
            .limit(Number(pageSize))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                let company = new company_user_to_1.CompanyUserTO();
                company.companyId = row.companyId;
                company.dni = row.dni;
                company.active = row.active;
                company.socialReason = row.socialReason;
                company.amountTenders = 0;
                return company;
            });
        });
    }
};
exports.CompanyRepositoryImpl = CompanyRepositoryImpl;
exports.CompanyRepositoryImpl = CompanyRepositoryImpl = CompanyRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)((0, common_1.forwardRef)(() => drizzle_provider_1.DBConfigService))),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], CompanyRepositoryImpl);
//# sourceMappingURL=company-repository-impl.js.map