"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var HistoryTenderRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HistoryTenderRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const util_1 = require("../../../domain/util");
let HistoryTenderRepositoryImpl = HistoryTenderRepositoryImpl_1 = class HistoryTenderRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(HistoryTenderRepositoryImpl_1.name);
    }
    async erraseUserHistoryTender(tenderInfo) {
        this.LOGGER.log(`ErraseUserHistoryTender - tenderId: ${tenderInfo.tenderId}`);
        const closeTender = util_1.TenderUtil.calculateTimeFromDateString(tenderInfo.details.Fechas.FechaCierre);
        const dateInfo = closeTender.length > 0 ? `Fecha de cierre: ${tenderInfo.details.Fechas.FechaCierre?.substring(0, 16).replace('T', ' ')}` : 'Fecha de cierre no informada';
        const publishDate = util_1.TenderUtil.calculateTimeFromDateString(tenderInfo.details.Fechas.FechaPublicacion);
        const datePublishInfo = publishDate.length > 0 ? `\n Fecha de publicación: ${tenderInfo.details.Fechas.FechaPublicacion?.substring(0, 16).replace('T', ' ')}` : 'Fecha de publicación no informada';
        const historyMetadata = {
            labelAmount: util_1.TenderUtil.convertToMillions(tenderInfo.details.MontoEstimado || 0),
            typeOfMoney: util_1.TenderUtil.convertToMillions(tenderInfo.details.MontoEstimado || 0) === '0' ? `${tenderInfo.details.Moneda} - ${tenderInfo.details.Tipo}` : tenderInfo.details.Moneda,
            labelLastUpdated: '-',
            labelCloseTender: dateInfo + datePublishInfo,
            description: tenderInfo.description,
            name: `${tenderInfo.code} - ${tenderInfo.details.Nombre.toUpperCase() || ''}`
        };
        await this.db.conn.update(framework_1.schema.userHistoryTenderTable)
            .set({ tenderId: null, codeTender: tenderInfo.code, metadata: historyMetadata })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.userHistoryTenderTable.tenderId, tenderInfo.tenderId)).execute();
    }
    async save(userId, tenderId) {
        this.LOGGER.log(`Save - userId: ${userId}, tenderId: ${tenderId}`);
        const existHistoryTender = await this.findByUserTender(userId, tenderId);
        if (existHistoryTender) {
            const validatedUserHistoryTender = framework_1.schema.userHistoryTenderTableUpdateSchema.parse({
                updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            });
            await this.db.conn
                .update(framework_1.schema.userHistoryTenderTable)
                .set(validatedUserHistoryTender)
                .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userHistoryTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userHistoryTenderTable.tenderId, tenderId)));
        }
        else {
            const validatedUserHistoryTender = framework_1.schema.userHistoryTenderTableInsertSchema.parse({
                userId: +userId,
                tenderId: +tenderId,
            });
            try {
                await this.db.conn
                    .insert(framework_1.schema.userHistoryTenderTable)
                    .values(validatedUserHistoryTender);
                return Promise.resolve(true);
            }
            catch (error) {
                throw new Error(error);
            }
        }
        return Promise.resolve(false);
    }
    async findByUserTender(userId, tenderId) {
        this.LOGGER.log(`findByUserTender - userId: ${userId}, tenderId: ${tenderId}`);
        return await this.selectUserHistoryTenderQuery()
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userHistoryTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userHistoryTenderTable.active, true), (0, drizzle_orm_1.eq)(framework_1.schema.userHistoryTenderTable.tenderId, tenderId)))
            .then((rows) => {
            if (rows.length === 0) {
                return undefined;
            }
            return rows[0];
        });
    }
    selectUserHistoryTenderQuery() {
        return this.db.conn
            .select({
            userId: framework_1.schema.userHistoryTenderTable.userId,
            tenderId: framework_1.schema.userHistoryTenderTable.tenderId,
            updatedAt: framework_1.schema.userHistoryTenderTable.updatedAt,
            createdAt: framework_1.schema.userHistoryTenderTable.createdAt,
            codeTender: framework_1.schema.userHistoryTenderTable.codeTender,
        })
            .from(framework_1.schema.userHistoryTenderTable)
            .$dynamic();
    }
    async getListTenderHistory(userId) {
        this.LOGGER.log(`GetListTenderHistory favorites only - userId: ${userId}`);
        return await this.db.conn
            .select({
            userId: framework_1.schema.userCompanyTenderTable.userId,
            tenderId: framework_1.schema.userCompanyTenderTable.tenderId,
            code: framework_1.schema.tenderTable.code,
        })
            .from(framework_1.schema.userCompanyTenderTable)
            .innerJoin(framework_1.schema.tenderTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.tenderId, framework_1.schema.tenderTable.id))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.active, true), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.isFavorite, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                return new domain_1.HistoryTender(row.userId, row.tenderId, row.code);
            });
        });
    }
};
exports.HistoryTenderRepositoryImpl = HistoryTenderRepositoryImpl;
exports.HistoryTenderRepositoryImpl = HistoryTenderRepositoryImpl = HistoryTenderRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], HistoryTenderRepositoryImpl);
//# sourceMappingURL=history-tender-repository-impl.js.map