import { TxType } from 'src/framework';
import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { KeywordRepository } from 'src/licitaapp/application';
import { Keyword, InsertKeyword, Metadata } from 'src/licitaapp/domain';
export declare class KeywordRepositoryImpl implements KeywordRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    findByCodeCategoriaMercadoPublico(codeCategoriaMercadoPublico: number[], tx?: TxType): Promise<Keyword[]>;
    findKeywordsByNameList(names: string[]): Promise<number[]>;
    findAdminValues(): Promise<string[]>;
    getAllWithouthMetadata(tx?: TxType): Promise<Keyword[]>;
    save(keyword: InsertKeyword, tx?: TxType): Promise<Keyword>;
    saveAll(keywords: InsertKeyword[], tx?: TxType): Promise<Keyword[]>;
    updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;
    findById(id: number, tx?: TxType): Promise<Keyword | null | undefined>;
    logicalRemove(id: number, tx?: TxType): Promise<void>;
}
