"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var KeywordRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeywordRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const util_1 = require("../../../domain/util");
let KeywordRepositoryImpl = KeywordRepositoryImpl_1 = class KeywordRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(KeywordRepositoryImpl_1.name);
    }
    async findByCodeCategoriaMercadoPublico(codeCategoriaMercadoPublico, tx) {
        this.LOGGER.log(`findByCodeCategoriaMercadoPublico codeCategoriaMercadoPublico: ${codeCategoriaMercadoPublico}`);
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.keywordTable.id,
            codeCategoriaMercadoPublico: framework_1.schema.keywordTable.codeCategoriaMercadoPublico,
        })
            .from(framework_1.schema.keywordTable)
            .where((0, drizzle_orm_1.inArray)(framework_1.schema.keywordTable.codeCategoriaMercadoPublico, codeCategoriaMercadoPublico))
            .then((rows) => {
            return rows.map((row) => {
                return new domain_1.Keyword(row.id, '', row.codeCategoriaMercadoPublico, domain_1.KeywordOrigin.MERCADO_PUBLICO);
            });
        });
    }
    async findKeywordsByNameList(names) {
        this.LOGGER.log(`findKeywordsByNameList names: ${names}`);
        return await (this.db.conn)
            .select({
            id: framework_1.schema.keywordTable.id,
        })
            .from(framework_1.schema.keywordTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.active, true), (0, drizzle_orm_1.inArray)(framework_1.schema.keywordTable.value, names)))
            .then((rows) => {
            return rows.map((row) => row.id);
        });
    }
    async findAdminValues() {
        this.LOGGER.log(`findAdminValues`);
        return await (this.db.conn)
            .select({
            value: framework_1.schema.keywordTable.value,
        })
            .from(framework_1.schema.keywordTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.active, true), (0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.origin, domain_1.KeywordOrigin.ADMIN)))
            .groupBy(framework_1.schema.keywordTable.value)
            .then((rows) => {
            return rows.map((row) => row.value);
        });
    }
    async getAllWithouthMetadata(tx) {
        this.LOGGER.log(`getAllWithouthMetadata`);
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.keywordTable.id,
            value: framework_1.schema.keywordTable.value,
            origin: framework_1.schema.keywordTable.origin,
            codeCategoriaMercadoPublico: framework_1.schema.keywordTable.codeCategoriaMercadoPublico,
        })
            .from(framework_1.schema.keywordTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.active, true), (0, drizzle_orm_1.isNull)(framework_1.schema.keywordTable.metadata)))
            .then((rows) => {
            return rows.map((row) => new domain_1.Keyword(row.id, row.value, row.codeCategoriaMercadoPublico, row.origin));
        });
    }
    async save(keyword, tx) {
        this.LOGGER.log(`save keyword: ${JSON.stringify(keyword)}`);
        const validatedKeyword = framework_1.schema.keywordTableInsertSchema.parse({
            value: keyword.value,
            origin: keyword.origin,
            active: true,
            codeCategoriaMercadoPublico: keyword.codeCategoriaMercadoPublico,
        });
        await (tx || this.db.conn).execute(drizzle_orm_1.sql.raw(`INSERT INTO keyword (active, value, origin, code_categoria_mercado_publico) VALUES 
          (true, '${keyword.value}', '${keyword.origin}', ${keyword.codeCategoriaMercadoPublico});`))
            .catch((err) => {
            this.LOGGER.error(`Error fetching registered users: ${err}`);
            throw new Error(`Error fetching registered users: ${err}`);
        });
        return new domain_1.Keyword(0, validatedKeyword.value, validatedKeyword.codeCategoriaMercadoPublico, validatedKeyword.origin, undefined);
    }
    async saveAll(keywords, tx) {
        if (keywords.length === 0) {
            return [];
        }
        const validatedKeywords = keywords.map((keyword) => framework_1.schema.keywordTableInsertSchema.parse({
            codeCategoriaMercadoPublico: keyword.codeCategoriaMercadoPublico,
            value: keyword.value,
            origin: keyword.origin,
            active: true,
        }));
        const insertedKeywordIds = await (tx || this.db.conn)
            .insert(framework_1.schema.keywordTable)
            .values(validatedKeywords)
            .$returningId()
            .then((rows) => {
            return rows.map((row) => row.id);
        });
        return await Promise.all(insertedKeywordIds.map((id) => this.findById(id))).then((keywords) => {
            return keywords.filter((keyword) => keyword !== null);
        });
    }
    async updateMetadata(keywordId, metadata) {
        this.LOGGER.log(`updateMetadata keyword: ${keywordId}`);
        await (this.db.conn)
            .update(framework_1.schema.keywordTable)
            .set({
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            metadata: metadata,
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.id, keywordId));
    }
    async findById(id, tx) {
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.keywordTable.id,
            value: framework_1.schema.keywordTable.value,
            origin: framework_1.schema.keywordTable.origin,
            codeCategoriaMercadoPublico: framework_1.schema.keywordTable.codeCategoriaMercadoPublico,
        })
            .from(framework_1.schema.keywordTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.id, id))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            return new domain_1.Keyword(rows[0].id, rows[0].value, rows[0].codeCategoriaMercadoPublico, rows[0].origin);
        });
    }
    async logicalRemove(id, tx) {
        this.LOGGER.log(`logicalRemove keyword: ${id}`);
        await (tx || this.db.conn)
            .update(framework_1.schema.keywordTable)
            .set({ active: false, deletedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.id, id));
    }
};
exports.KeywordRepositoryImpl = KeywordRepositoryImpl;
exports.KeywordRepositoryImpl = KeywordRepositoryImpl = KeywordRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], KeywordRepositoryImpl);
//# sourceMappingURL=keyword-repository-impl.js.map