import { TxType } from 'src/framework';
import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { MatchingWordRepository } from 'src/licitaapp/application/repository/matching_word-repository/matching_word-repository.interface';
import { InsertMatchingWord, MatchingWord, UpdateMatchingWord } from 'src/licitaapp/domain';
export declare class MatchingWordRepositoryImpl implements MatchingWordRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    getPagination(page: number, pageSize: number, subdivisionId?: string, wordSearch?: string): Promise<MatchingWord[]>;
    mapRowToEntity(rowRecord: any): MatchingWord;
    findAll(): Promise<MatchingWord[]>;
    findById(matchingWordId: number, tx?: TxType): Promise<MatchingWord | null | undefined>;
    save(matchingWord: InsertMatchingWord, tx?: TxType): Promise<boolean>;
    update(matchingWord: UpdateMatchingWord, tx?: TxType): Promise<boolean>;
    delete(matchingWordId: number, tx?: TxType): Promise<boolean>;
}
