"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MatchingWordRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchingWordRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const util_1 = require("../../../domain/util");
let MatchingWordRepositoryImpl = MatchingWordRepositoryImpl_1 = class MatchingWordRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(MatchingWordRepositoryImpl_1.name);
    }
    async getPagination(page, pageSize, subdivisionId, wordSearch) {
        this.LOGGER.log(`pagination - page: ${page}, pageSize: ${pageSize}, subdivisionId: ${subdivisionId}, wordSearch: ${wordSearch}`);
        const offset = (page - 1) * pageSize;
        const selectFields = {
            id: framework_1.schema.matchingWordTable.id,
            coincidence: framework_1.schema.matchingWordTable.coincidence,
            subdivisionId: framework_1.schema.matchingWordTable.subdivisionId,
            subdivision: framework_1.schema.subdivisionTable
        };
        let query = this.db.conn
            .select(selectFields)
            .from(framework_1.schema.matchingWordTable)
            .leftJoin(framework_1.schema.subdivisionTable, (0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.subdivisionId, framework_1.schema.subdivisionTable.id))
            .where((0, drizzle_orm_1.or)((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.active, true), (0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.subdivisionId, +subdivisionId), ...(wordSearch ? [(0, drizzle_orm_1.like)(framework_1.schema.matchingWordTable.coincidence, `%${wordSearch}%`)] : [])), (0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.active, true), (0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.subdivisionId, +subdivisionId), ...(wordSearch ? [(0, drizzle_orm_1.like)(framework_1.schema.matchingWordTable.coincidence, `%${wordSearch.toUpperCase()}%`)] : []))))
            .limit(Number(pageSize))
            .offset(offset);
        const rows = await query;
        if (rows.length === 0) {
            return [];
        }
        return rows.map((row) => {
            return this.mapRowToEntity(row);
        });
    }
    mapRowToEntity(rowRecord) {
        return new domain_1.MatchingWord(rowRecord.id, rowRecord.coincidence, rowRecord.subdivision ? rowRecord.subdivision : null, rowRecord.subdivisionId);
    }
    findAll() {
        this.LOGGER.log('Finding all matching words');
        return this.db.conn
            .select({
            id: framework_1.schema.matchingWordTable.id,
            coincidence: framework_1.schema.matchingWordTable.coincidence,
            subdivisionId: framework_1.schema.matchingWordTable.subdivisionId,
        })
            .from(framework_1.schema.matchingWordTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.active, true))
            .then((rows) => rows.map((row) => this.mapRowToEntity(row)));
    }
    async findById(matchingWordId, tx) {
        this.LOGGER.log(`Finding matching word with ID: ${matchingWordId}`);
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.matchingWordTable.id,
            coincidence: framework_1.schema.matchingWordTable.coincidence,
            subdivisionId: framework_1.schema.matchingWordTable.subdivisionId,
        })
            .from(framework_1.schema.matchingWordTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.id, matchingWordId))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            return this.mapRowToEntity(rows[0]);
        });
    }
    async save(matchingWord, tx) {
        this.LOGGER.log(`Saving matching word: ${JSON.stringify(matchingWord)}`);
        const validatedMatchingWord = framework_1.schema.matchingWordTableInsertSchema.parse({
            coincidence: matchingWord.coincidence,
            subdivisionId: matchingWord.subdivisionId,
        });
        return (tx || this.db.conn)
            .insert(framework_1.schema.matchingWordTable)
            .values(validatedMatchingWord)
            .then(() => true);
    }
    async update(matchingWord, tx) {
        this.LOGGER.log(`Updating matching word with ID: ${matchingWord.id}`);
        const validatedMatchingWord = framework_1.schema.matchingWordTableUpdateSchema.parse({
            subdivisionId: matchingWord.subdivisionId,
            coincidence: matchingWord.coincidence,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
        });
        await this.db.conn
            .update(framework_1.schema.matchingWordTable)
            .set(validatedMatchingWord)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.id, matchingWord.id))
            .execute();
        return true;
    }
    async delete(matchingWordId, tx) {
        await (this.db.conn)
            .update(framework_1.schema.matchingWordTable)
            .set({
            active: false,
            deletedAt: util_1.TenderUtil.getCurrentSystemDate(),
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.matchingWordTable.id, matchingWordId));
        return true;
    }
};
exports.MatchingWordRepositoryImpl = MatchingWordRepositoryImpl;
exports.MatchingWordRepositoryImpl = MatchingWordRepositoryImpl = MatchingWordRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], MatchingWordRepositoryImpl);
//# sourceMappingURL=matching_word-repository-impl.js.map