import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { TenderKeywordCategoryRepository } from 'src/licitaapp/application/repository/tender-keyword-category-repository/tender-keyword-category-repository.interface';
import { InsertTenderKeywordCategory, TenderKeywordCategory } from 'src/licitaapp/domain/entities/tender-keyword-category.entity';
export declare class TenderKeywordCategoryRepositoryImpl implements TenderKeywordCategoryRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    findAllByWordFilter(wordFilter: string, returnNormalTender: boolean): Promise<number[]>;
    findAllByCodeMercadoPublico(codeMercadoPublico: number[], returnNormalTender: boolean): Promise<number[]>;
    saveAgileTenderCategory(tenderId: number, codeMercadoPublico: string, itemDescription: string): Promise<void>;
    saveNormalTenderCategory(tenderId: number, codeMercadoPublico: string, itemDescription: string): Promise<void>;
    errase(tenderKeywordCategoryId: number): Promise<void>;
    findAllByNormaltenderId(normalTenderId: number): Promise<TenderKeywordCategory[]>;
    findAllByAgileTenderId(agileTenderId: number): Promise<TenderKeywordCategory[]>;
    upsert(insertData: InsertTenderKeywordCategory): Promise<number>;
    private mapRowToTenderKeywordCategory;
}
