"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TenderKeywordCategoryRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderKeywordCategoryRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const tender_keyword_category_entity_1 = require("../../../domain/entities/tender-keyword-category.entity");
const util_1 = require("../../../domain/util");
let TenderKeywordCategoryRepositoryImpl = TenderKeywordCategoryRepositoryImpl_1 = class TenderKeywordCategoryRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(TenderKeywordCategoryRepositoryImpl_1.name);
    }
    async findAllByWordFilter(wordFilter, returnNormalTender) {
        this.LOGGER.log(`findAllByWordFilter wordFilter: ${wordFilter} returnNormalTender: ${returnNormalTender}`);
        const whereSql = returnNormalTender ?
            (0, drizzle_orm_1.and)((0, drizzle_orm_1.isNull)(framework_1.schema.tenderKeywordCategoryTable.agileTenderId), (0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.active, true), (0, drizzle_orm_1.like)(framework_1.schema.tenderKeywordCategoryTable.itemDescription, `%${wordFilter}%`)) :
            (0, drizzle_orm_1.and)((0, drizzle_orm_1.isNull)(framework_1.schema.tenderKeywordCategoryTable.normalTenderId), (0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.active, true), (0, drizzle_orm_1.like)(framework_1.schema.tenderKeywordCategoryTable.itemDescription, `%${wordFilter}%`));
        return await (this.db.conn)
            .select({
            agileTenderId: framework_1.schema.tenderKeywordCategoryTable.agileTenderId,
            normalTenderId: framework_1.schema.tenderKeywordCategoryTable.normalTenderId,
        })
            .from(framework_1.schema.tenderKeywordCategoryTable)
            .where(whereSql).then((rows) => {
            return rows.map((row) => returnNormalTender ? row.normalTenderId : row.agileTenderId);
        });
    }
    async findAllByCodeMercadoPublico(codeMercadoPublico, returnNormalTender) {
        this.LOGGER.log(`findAllByCodeMercadoPublico codeMercadoPublico: ${codeMercadoPublico} returnNormalTender: ${returnNormalTender}`);
        const whereSql = returnNormalTender ?
            (0, drizzle_orm_1.and)((0, drizzle_orm_1.isNull)(framework_1.schema.tenderKeywordCategoryTable.agileTenderId), (0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.active, true), (0, drizzle_orm_1.inArray)(framework_1.schema.tenderKeywordCategoryTable.codeMercadoPublico, codeMercadoPublico)) :
            (0, drizzle_orm_1.and)((0, drizzle_orm_1.isNull)(framework_1.schema.tenderKeywordCategoryTable.normalTenderId), (0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.active, true), (0, drizzle_orm_1.inArray)(framework_1.schema.tenderKeywordCategoryTable.codeMercadoPublico, codeMercadoPublico));
        return await (this.db.conn)
            .select({
            agileTenderId: framework_1.schema.tenderKeywordCategoryTable.agileTenderId,
            normalTenderId: framework_1.schema.tenderKeywordCategoryTable.normalTenderId,
        })
            .from(framework_1.schema.tenderKeywordCategoryTable)
            .where(whereSql).then((rows) => {
            return rows.map((row) => returnNormalTender ? row.normalTenderId : row.agileTenderId);
        });
    }
    async saveAgileTenderCategory(tenderId, codeMercadoPublico, itemDescription) {
        this.LOGGER.log(`saveAgileTenderCategory tenderId: ${tenderId} codeMercadoPublico: ${codeMercadoPublico}`);
        await this.upsert({
            agileTenderId: tenderId,
            codeMercadoPublico: parseInt(codeMercadoPublico),
            itemDescription: itemDescription,
        });
    }
    async saveNormalTenderCategory(tenderId, codeMercadoPublico, itemDescription) {
        this.LOGGER.log(`saveNormalTenderCategory tenderId: ${tenderId} codeMercadoPublico: ${codeMercadoPublico}`);
        await this.upsert({
            normalTenderId: tenderId,
            codeMercadoPublico: parseInt(codeMercadoPublico),
            itemDescription: itemDescription,
        });
        return Promise.resolve();
    }
    async errase(tenderKeywordCategoryId) {
        this.LOGGER.log(`delete tenderKeywordCategoryId: ${tenderKeywordCategoryId}`);
        await (this.db.conn)
            .delete(framework_1.schema.tenderKeywordCategoryTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.id, tenderKeywordCategoryId)).execute();
    }
    async findAllByNormaltenderId(normalTenderId) {
        this.LOGGER.log(`findByNormalTenderId normalTenderId: ${normalTenderId}`);
        return await (this.db.conn)
            .select({
            id: framework_1.schema.tenderKeywordCategoryTable.id,
            agileTenderId: framework_1.schema.tenderKeywordCategoryTable.agileTenderId,
            normalTenderId: framework_1.schema.tenderKeywordCategoryTable.normalTenderId,
            codeMercadoPublico: framework_1.schema.tenderKeywordCategoryTable.codeMercadoPublico,
            itemDescription: framework_1.schema.tenderKeywordCategoryTable.itemDescription,
        })
            .from(framework_1.schema.tenderKeywordCategoryTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.normalTenderId, normalTenderId), (0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.active, true))).then((rows) => {
            return this.mapRowToTenderKeywordCategory(rows);
        });
    }
    async findAllByAgileTenderId(agileTenderId) {
        this.LOGGER.log(`findByAgileTenderId agileTenderId: ${agileTenderId}`);
        return await this.db.conn
            .select({
            id: framework_1.schema.tenderKeywordCategoryTable.id,
            agileTenderId: framework_1.schema.tenderKeywordCategoryTable.agileTenderId,
            normalTenderId: framework_1.schema.tenderKeywordCategoryTable.normalTenderId,
            codeMercadoPublico: framework_1.schema.tenderKeywordCategoryTable.codeMercadoPublico,
            itemDescription: framework_1.schema.tenderKeywordCategoryTable.itemDescription,
        })
            .from(framework_1.schema.tenderKeywordCategoryTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.agileTenderId, agileTenderId), (0, drizzle_orm_1.eq)(framework_1.schema.tenderKeywordCategoryTable.active, true))).then((rows) => {
            return this.mapRowToTenderKeywordCategory(rows);
        });
    }
    async upsert(insertData) {
        this.LOGGER.log(`upsert insertData: ${JSON.stringify(insertData)}`);
        const validatedTender = framework_1.schema.tenderKeywordCategoryTableInsertSchema.parse({
            agileTenderId: insertData.agileTenderId,
            normalTenderId: insertData.normalTenderId,
            codeMercadoPublico: insertData.codeMercadoPublico,
            itemDescription: insertData.itemDescription,
        });
        const insertedTenderId = await this.db.conn
            .insert(framework_1.schema.tenderKeywordCategoryTable)
            .values({
            agileTenderId: validatedTender.agileTenderId,
            normalTenderId: validatedTender.normalTenderId,
            codeMercadoPublico: validatedTender.codeMercadoPublico,
            itemDescription: validatedTender.itemDescription,
        })
            .onDuplicateKeyUpdate({
            set: {
                agileTenderId: validatedTender.agileTenderId,
                normalTenderId: validatedTender.normalTenderId,
                codeMercadoPublico: validatedTender.codeMercadoPublico,
                itemDescription: validatedTender.itemDescription,
                updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            },
        })
            .$returningId()
            .then((rows) => {
            return rows[0].id;
        });
        return insertedTenderId;
    }
    mapRowToTenderKeywordCategory(rows) {
        return rows.map((row) => new tender_keyword_category_entity_1.TenderKeywordCategory(row.id, row.codeMercadoPublico, row.itemDescription, row.agileTenderId, row.normalTenderId));
    }
};
exports.TenderKeywordCategoryRepositoryImpl = TenderKeywordCategoryRepositoryImpl;
exports.TenderKeywordCategoryRepositoryImpl = TenderKeywordCategoryRepositoryImpl = TenderKeywordCategoryRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], TenderKeywordCategoryRepositoryImpl);
//# sourceMappingURL=tender-keyword-category-repository-impl.js.map