import { ConfigService } from '@nestjs/config';
import { TenderRepository, Licitacion, AgileTenderFullInfoTO } from 'src/licitaapp';
import { GeneralDataInfoTO, InsertTender, PaginationNormalTenderTO, RequestTender, Tender, TenderHistoryTO, TenderTO } from 'src/licitaapp/domain';
import { AgileTender, InsertAgileTender, MinimalToEditAgileTender, UpdateMinimalToEditAgileTender } from 'src/licitaapp/domain/entities/agile-tender.entity';
import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { PaginationAgileTenderTO } from 'src/licitaapp/domain/dto/pagination-agile-tender.to';
export declare class TenderRepositoryImpl implements TenderRepository {
    private readonly db;
    private readonly configService;
    private readonly LOGGER;
    private readonly limitGeoTendersDashboard;
    constructor(db: DBConfigService, configService: ConfigService);
    createGeneralDataQuery(): Promise<GeneralDataInfoTO>;
    getNormalTenderAdminPaginated(page: number, pageSize: number, order: string, filter: string): Promise<PaginationNormalTenderTO[]>;
    getAgileTenderMinimalToEditById(agileTenderId: number): Promise<MinimalToEditAgileTender | undefined>;
    updateMinimalAgileTender(dataAgiletender: UpdateMinimalToEditAgileTender): Promise<void>;
    getAgileTenderById(agileTenderId: number): Promise<AgileTender | null | undefined>;
    getAgileTenderAdminPaginated(page: number, pageSize: number, order: string, filter: string): Promise<PaginationAgileTenderTO[]>;
    findByColumnLike(column: string, value: string): Promise<Tender[]>;
    erraseAgileOldTenders(agileTenderIds: number[]): Promise<void>;
    getAgileTenderPaginated(page: number, pageSize: number, typeSearch: string, subdivisionIds: number[], companyId: number, userId: number): Promise<AgileTenderFullInfoTO[]>;
    getTotalAmountAgileTenders(userId: number, companyId: number, subdivisionIds: number[]): Promise<{
        favoriteMoney: number;
        totalMoney: number;
        totalSubdivision: number;
        agileKeywordAmount: number;
    }>;
    findInfohistoryTender(tenderId: number[]): Promise<TenderHistoryTO[]>;
    erraseByListId(tenderIds: number[]): Promise<void>;
    findByCode(code: string): Promise<Tender | undefined>;
    logicalRemove(tenderId: number): Promise<void>;
    findByDates(initDate: Date, endDate: Date): Promise<RequestTender[]>;
    findWithoutCloseDate(): Promise<Tender[]>;
    findWithoutSubdivision(): Promise<Tender[]>;
    findByCloseDate(endDate: Date): Promise<Tender[]>;
    findByCloseDateAgileTender(endDate: Date): Promise<number[]>;
    findByDatesUpset(initDate: Date, endDate: Date): Promise<Tender[]>;
    findById(id: number): Promise<Tender | undefined>;
    findBySubdivisionId(subdivisionId: number, withLimit?: boolean): Promise<Tender[]>;
    upsert(tender: InsertTender): Promise<number>;
    countActiveTenders(): Promise<number>;
    getLogicalRemoveTenderIds(): Promise<TenderTO[]>;
    updateField(tender: {
        id: number;
        active: boolean;
        detail?: Licitacion;
        subdivisionId?: number | null;
    }): Promise<void>;
    updateCloseDate(tender: {
        id: number;
        closeDate: Date | null;
    }): Promise<void>;
    updateLogicalRemove(tender: {
        id: number;
        state: boolean;
    }): Promise<void>;
    updateSubdivision(tender: {
        id: number;
        subdivisionId?: number | null;
    }): Promise<void>;
    private selectTenderQuery;
    private mapRowToTender;
    private mapRowToAgileTender;
    upsertAgileTender(tender: InsertAgileTender): Promise<number>;
    getAgileTenderWithouthMetadata(): Promise<AgileTender[]>;
}
