"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TenderRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const domain_1 = require("../../../domain");
const agile_tender_entity_1 = require("../../../domain/entities/agile-tender.entity");
const util_1 = require("../../../domain/util");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const pagination_agile_tender_to_1 = require("../../../domain/dto/pagination-agile-tender.to");
let TenderRepositoryImpl = TenderRepositoryImpl_1 = class TenderRepositoryImpl {
    constructor(db, configService) {
        this.db = db;
        this.configService = configService;
        this.LOGGER = new framework_1.PrimeLogger(TenderRepositoryImpl_1.name);
        this.limitGeoTendersDashboard = this.configService.get('LIMIT_GEO_TENDERS_DASHBOARD', 5);
    }
    async createGeneralDataQuery() {
        const outPut = new domain_1.GeneralDataInfoTO();
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(`select count(id) as amount from company where active=1`)).then((rows) => {
            const items = rows[0];
            outPut.companyNumber = Number(items[0].amount ? items[0].amount : 0);
        });
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(`select count(id) as amount from user where active=1`)).then((rows) => {
            const items = rows[0];
            outPut.usersNumber = Number(items[0].amount ? items[0].amount : 0);
        });
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(`select count(id) as amount from tender_agile where active=1`)).then((rows) => {
            const items = rows[0];
            outPut.agileTenderNumber = Number(items[0].amount ? items[0].amount : 0);
        });
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(`select count(id) as amount from tender where active=1`)).then((rows) => {
            const items = rows[0];
            outPut.normalTenderNumber = Number(items[0].amount ? items[0].amount : 0);
        });
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(`SELECT COUNT(id) AS amount FROM user WHERE last_access >= CURDATE() AND last_access < CURDATE() + INTERVAL 1 DAY`)).then((rows) => {
            const items = rows[0];
            outPut.activeNumber = Number(items[0].amount ? items[0].amount : 0);
        });
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(`SELECT name, last_name FROM user WHERE active=1 ORDER BY last_access DESC LIMIT 1`)).then((rows) => {
            const items = rows[0];
            outPut.fullNameLastAccess = items[0].name ? items[0].name : '' + ' ' + (items[0].last_name ? items[0].last_name : '');
        });
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(`SELECT name, last_name FROM user WHERE active=1 ORDER BY created_at DESC LIMIT 1`)).then((rows) => {
            const items = rows[0];
            outPut.fullNameLastRegister = items[0].name ? items[0].name : '' + ' ' + (items[0].last_name ? items[0].last_name : '');
        });
        return outPut;
    }
    async getNormalTenderAdminPaginated(page, pageSize, order, filter) {
        this.LOGGER.log(`getAgileTenderAdminPaginated page ${page} pageSize ${pageSize} order ${order} filter ${filter}`);
        const offset = (page - 1) * pageSize;
        const outPutList = [];
        let query = `SELECT id, code, name, description, subdivision_id, close_date FROM tender`;
        if (filter && filter.trim() !== '') {
            query += ` WHERE name like('%${filter}%') or name like('%${filter.toUpperCase()}%')`;
            query += ` AND description like('%${filter}%') or description like('%${filter.toUpperCase()}%')`;
        }
        query += ` ORDER BY ${order}
           LIMIT ${pageSize} OFFSET ${offset};`;
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(query)).then((rows) => {
            const items = rows[0];
            items.forEach((item) => {
                const out = new domain_1.PaginationNormalTenderTO();
                out.id = item.id,
                    out.code = item.code;
                out.name = item.name;
                out.description = item.description;
                out.subdivisionId = item.subdivision_id;
                out.closeDate = item.close_date;
                outPutList.push(out);
            });
        });
        return outPutList;
    }
    async getAgileTenderMinimalToEditById(agileTenderId) {
        this.LOGGER.log(`getAgileTenderMinimalToEditById - agileTenderId: ${agileTenderId}`);
        return await this.db.conn
            .select({
            description: framework_1.schema.agileTenderTable.description,
            subdivisionId: framework_1.schema.agileTenderTable.subdivisionId,
        })
            .from(framework_1.schema.agileTenderTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.agileTenderTable.id, agileTenderId))
            .then((row) => {
            if (row.length === 0) {
                return undefined;
            }
            const output = new agile_tender_entity_1.MinimalToEditAgileTender();
            output.description = row[0].description;
            output.subdivisionId = row[0].subdivisionId;
            return output;
        });
    }
    async updateMinimalAgileTender(dataAgiletender) {
        this.LOGGER.log(`updateMinimalAgileTender - agileTenderId: ${dataAgiletender}`);
        await this.db.conn
            .update(framework_1.schema.agileTenderTable)
            .set({ description: dataAgiletender.description, subdivisionId: dataAgiletender.subdivisionId, updatedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.agileTenderTable.id, dataAgiletender.id))
            .execute();
    }
    async getAgileTenderById(agileTenderId) {
        this.LOGGER.log(`getAgileTenderById - agileTenderId: ${agileTenderId}`);
        return await this.db.conn
            .select({
            id: framework_1.schema.agileTenderTable.id,
            code: framework_1.schema.agileTenderTable.code,
            name: framework_1.schema.agileTenderTable.name,
            description: framework_1.schema.agileTenderTable.description,
            details: framework_1.schema.agileTenderTable.details,
            createdAt: framework_1.schema.agileTenderTable.createdAt,
            updatedAt: framework_1.schema.agileTenderTable.updatedAt,
            closeDate: framework_1.schema.agileTenderTable.closeDate,
            subdivisionId: framework_1.schema.agileTenderTable.subdivisionId,
            descriptionLocation: framework_1.schema.agileTenderTable.descriptionLocation,
        })
            .from(framework_1.schema.agileTenderTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.agileTenderTable.id, agileTenderId))
            .then((row) => {
            if (row.length === 0) {
                return undefined;
            }
            return this.mapRowToAgileTender([row[0]])[0];
        });
    }
    async getAgileTenderAdminPaginated(page, pageSize, order, filter) {
        this.LOGGER.log(`getAgileTenderAdminPaginated page ${page} pageSize ${pageSize} order ${order} filter ${filter}`);
        const offset = (page - 1) * pageSize;
        const outPutList = [];
        let query = `SELECT id, code, name, description, close_date
           FROM tender_agile`;
        if (filter && filter.trim() !== '') {
            query += ` WHERE details like('%${filter}%') or details like('%${filter.toUpperCase()}%')`;
        }
        query += ` ORDER BY ${order}
           LIMIT ${pageSize} OFFSET ${offset};`;
        await (this.db.conn).execute(drizzle_orm_1.sql.raw(query)).then((rows) => {
            const items = rows[0];
            items.forEach((item) => {
                const out = new pagination_agile_tender_to_1.PaginationAgileTenderTO();
                out.id = item.id,
                    out.code = item.code;
                out.name = item.name;
                out.description = item.description;
                outPutList.push(out);
            });
        });
        return outPutList;
    }
    async findByColumnLike(column, value) {
        this.LOGGER.log(`findByColumnLike column: ${column} value: ${value}`);
        var listTender = [];
        let querySQL = '';
        if ('description' === column) {
            querySQL = `SELECT * FROM tender WHERE MATCH(description) AGAINST ('${value}' IN NATURAL LANGUAGE MODE)`;
        }
        else {
            querySQL = `SELECT * FROM tender WHERE LOWER(details) LIKE LOWER('%${value}%');`;
        }
        await this.db.conn.execute(querySQL).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        });
        return listTender;
    }
    erraseAgileOldTenders(agileTenderIds) {
        this.LOGGER.log(`erraseAgileOldTenders Agile Tender IDs: ${agileTenderIds}`);
        this.db.conn.delete(framework_1.schema.agileTenderTable)
            .where((0, drizzle_orm_1.inArray)(framework_1.schema.agileTenderTable.id, agileTenderIds)).execute();
        return Promise.resolve();
    }
    async getAgileTenderPaginated(page, pageSize, typeSearch, subdivisionIds, companyId, userId) {
        this.LOGGER.log(`pagination agile page ${page} pageSize ${pageSize} typeSearch ${typeSearch} subdivisionIds ${subdivisionIds} companyId ${companyId}`);
        const offset = (page - 1) * pageSize;
        let whereSentence = (0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.agileTenderTable.active, true));
        if (typeSearch === 'keyword') {
            whereSentence = (0, drizzle_orm_1.and)(whereSentence, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.companyId, companyId));
            return await this.db.conn.
                select({
                details: framework_1.schema.agileTenderTable.details,
                createdAt: framework_1.schema.agileTenderTable.createdAt,
                updatedAt: framework_1.schema.agileTenderTable.updatedAt,
                tenderAgileId: framework_1.schema.agileTenderTable.id,
                closeDate: framework_1.schema.agileTenderTable.closeDate,
            })
                .from(framework_1.schema.userCompanyAgileTenderTable)
                .leftJoin(framework_1.schema.agileTenderTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.agileTenderId, framework_1.schema.agileTenderTable.id))
                .where(whereSentence)
                .orderBy((0, drizzle_orm_1.desc)(framework_1.schema.agileTenderTable.closeDate))
                .offset(offset)
                .limit(Number(pageSize))
                .then((rows) => {
                if (rows.length === 0) {
                    return [];
                }
                return rows.map((row) => {
                    const out = row.details;
                    out.general.lastUpdatedAt = row.updatedAt ? row.updatedAt : row.createdAt;
                    out.general.tenderAgileId = row.tenderAgileId;
                    out.general.closeDate = row.closeDate;
                    return out;
                });
            });
        }
        else if (typeSearch === 'subdivision' && subdivisionIds.length > 0) {
            whereSentence = (0, drizzle_orm_1.and)(whereSentence, (0, drizzle_orm_1.inArray)(framework_1.schema.agileTenderTable.subdivisionId, subdivisionIds));
        }
        else if (typeSearch === 'uncategorized') {
            whereSentence = (0, drizzle_orm_1.and)(whereSentence, (0, drizzle_orm_1.isNull)(framework_1.schema.agileTenderTable.subdivisionId));
        }
        return await this.db.conn.
            select({
            details: framework_1.schema.agileTenderTable.details,
            createdAt: framework_1.schema.agileTenderTable.createdAt,
            updatedAt: framework_1.schema.agileTenderTable.updatedAt,
            tenderAgileId: framework_1.schema.agileTenderTable.id,
            closeDate: framework_1.schema.agileTenderTable.closeDate,
        })
            .from(framework_1.schema.agileTenderTable)
            .where(whereSentence)
            .orderBy((0, drizzle_orm_1.desc)(framework_1.schema.agileTenderTable.closeDate))
            .offset(offset)
            .limit(Number(pageSize))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                const out = row.details;
                out.general.lastUpdatedAt = row.updatedAt ? row.updatedAt : row.createdAt;
                out.general.tenderAgileId = row.tenderAgileId;
                out.general.closeDate = row.closeDate;
                return out;
            });
        });
    }
    async getTotalAmountAgileTenders(userId, companyId, subdivisionIds) {
        this.LOGGER.log(`getTotalAmountAgileTenders userId: ${userId}, companyId: ${companyId}, subdivisionIds: ${subdivisionIds}`);
        const output = {
            totalMoney: 0,
            totalSubdivision: 0,
            agileKeywordAmount: 0,
            favoriteMoney: 0,
        };
        await this.db.conn.execute(`SELECT count(id) AS total_amount_clp FROM tender_agile WHERE active = 1`).then((rows) => {
            const items = rows[0];
            output.totalMoney = Number(items[0].total_amount_clp ? items[0].total_amount_clp : 0);
        });
        await this.db.conn.execute(`SELECT subdivision_id, SUM(amount_clp) AS total_amount_clp FROM tender_agile WHERE deleted_at IS NULL
  AND active = 1 AND subdivision_id IN (${subdivisionIds.join(',')}) GROUP BY subdivision_id`).then((rows) => {
            const items = rows[0];
            let amountPerSubdivision = 0;
            items.forEach((item) => {
                amountPerSubdivision += Number(item.total_amount_clp ? item.total_amount_clp : 0);
            });
            output.totalSubdivision = amountPerSubdivision;
        });
        await this.db.conn.execute(`SELECT SUM(ta.amount_clp) AS total_amount_clp FROM 
            user_company_agile_tender tkc LEFT JOIN tender_agile ta 
        ON tkc.agile_tender_id = ta.id WHERE tkc.user_id=${userId} and tkc.is_favorite=1 and 
            tkc.company_id=${companyId} AND tkc.active = 1 AND ta.active = 1 GROUP BY ta.code`).then((rows) => {
            const items = rows[0];
            let favoriteMoney = 0;
            items.forEach((item) => {
                favoriteMoney += Number(item.total_amount_clp ? item.total_amount_clp : 0);
            });
            output.favoriteMoney = favoriteMoney;
        });
        await this.db.conn.execute(`SELECT SUM(ta.amount_clp) AS total_amount_clp FROM 
          user_company_agile_tender tkc LEFT JOIN tender_agile ta 
      ON tkc.agile_tender_id = ta.id WHERE tkc.user_id=${userId} and 
          tkc.company_id=${companyId} AND tkc.active = 1 AND ta.active = 1 GROUP BY ta.code`).then((rows) => {
            const items = rows[0];
            let agileKeywordAmount = 0;
            items.forEach((item) => {
                agileKeywordAmount += Number(item.total_amount_clp ? item.total_amount_clp : 0);
            });
            output.agileKeywordAmount = agileKeywordAmount;
        });
        return output;
    }
    async findInfohistoryTender(tenderId) {
        this.LOGGER.log(`findInfohistoryTender Tender IDs: ${tenderId.filter(id => id != 0)}`);
        if (tenderId.length === 0) {
            return [];
        }
        const selectFields = {
            tenderId: framework_1.schema.tenderTable.id,
            code: framework_1.schema.tenderTable.code,
            name: framework_1.schema.tenderTable.name,
            description: framework_1.schema.tenderTable.description,
            details: framework_1.schema.tenderTable.details,
            createdAt: framework_1.schema.tenderTable.createdAt,
            updatedAt: framework_1.schema.tenderTable.updatedAt,
        };
        return await (this.db.conn)
            .select(selectFields)
            .from(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.inArray)(framework_1.schema.tenderTable.id, tenderId.filter(id => id != 0)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                return {
                    tenderId: row.tenderId,
                    code: row.code,
                    name: row.name,
                    description: row.description,
                    details: row.details,
                    createdAt: row.createdAt,
                    updatedAt: row.updatedAt,
                };
            });
        });
    }
    async erraseByListId(tenderIds) {
        this.LOGGER.log(`erraseByListId Tender IDs: ${tenderIds}`);
        await this.db.conn
            .delete(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.inArray)(framework_1.schema.tenderTable.id, tenderIds)).execute();
    }
    async findByCode(code) {
        return await this.selectTenderQuery()
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.code, code), (0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return undefined;
            }
            return this.mapRowToTender(rows[0]);
        });
    }
    async logicalRemove(tenderId) {
        this.LOGGER.log(`logicalRemove Tender: ${tenderId}`);
        await (this.db.conn)
            .update(framework_1.schema.tenderTable)
            .set({
            active: false,
            deletedAt: util_1.TenderUtil.getCurrentSystemDate(),
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tenderId));
    }
    async findByDates(initDate, endDate) {
        this.LOGGER.log(`findByDates - initDate: ${initDate} endDate: ${endDate}`);
        var listTender = [];
        await this.db.conn.execute(`SELECT id, code, name, description, metadata FROM tender WHERE created_at BETWEEN '${initDate.toISOString().slice(0, 19).replace("T", " ")}' AND '${endDate.toISOString().slice(0, 19).replace("T", " ")}' AND active = true AND metadata IS NOT NULL`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                const newTender = new domain_1.RequestTender();
                newTender.id = item.id;
                newTender.code = item.code;
                newTender.name = item.name;
                newTender.description = item.description;
                newTender.metadata = item.metadata;
                return newTender;
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findByDates: ${err}`);
        });
        return listTender;
    }
    async findWithoutCloseDate() {
        this.LOGGER.log(`findWithoutCloseDate`);
        var listTender = [];
        await this.db.conn.execute(`SELECT * FROM tender WHERE close_date IS NULL`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findWithoutCloseDate: ${err}`);
        });
        return listTender;
    }
    async findWithoutSubdivision() {
        this.LOGGER.log(`findWithoutCity`);
        var listTender = [];
        await this.db.conn.execute(`SELECT * FROM tender WHERE subdivision_id IS NULL`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findWithoutCity: ${err}`);
        });
        return listTender;
    }
    async findByCloseDate(endDate) {
        this.LOGGER.log(`findByCloaseDate - endDate: ${endDate}`);
        var listTender = [];
        await this.db.conn.execute(`SELECT * FROM tender WHERE close_date <= '${endDate.toISOString().slice(0, 19).replace("T", " ")}'`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findByCloseDate: ${err}`);
        });
        return listTender;
    }
    async findByCloseDateAgileTender(endDate) {
        this.LOGGER.log(`findByCloseDateAgileTender - endDate: ${endDate}`);
        var listTender = [];
        await this.db.conn.execute(`SELECT id FROM agile_tender WHERE close_date <= '${endDate.toISOString().slice(0, 19).replace("T", " ")}' AND active = true`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return item;
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findByCloseDate: ${err}`);
        });
        return listTender;
    }
    async findByDatesUpset(initDate, endDate) {
        this.LOGGER.log(`findByDates - initDate: ${initDate.toISOString().slice(0, 19).replace("T", " ")} endDate: ${endDate.toISOString().slice(0, 19).replace("T", " ")}`);
        var listTender = [];
        await this.db.conn.execute(`SELECT * FROM tender WHERE created_at BETWEEN '${initDate.toISOString().slice(0, 19).replace("T", " ")}' AND '${endDate.toISOString().slice(0, 19).replace("T", " ")}' AND active = true OR 
      updated_at BETWEEN '${initDate.toISOString().slice(0, 19).replace("T", " ")}' AND '${endDate.toISOString().slice(0, 19).replace("T", " ")}' AND active = true`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findByDates: ${err}`);
        });
        return listTender;
    }
    async findById(id) {
        return await this.selectTenderQuery()
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, id), (0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return undefined;
            }
            return this.mapRowToTender(rows[0]);
        });
    }
    async findBySubdivisionId(subdivisionId, withLimit = false) {
        try {
            const query = this.selectTenderQuery()
                .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.subdivisionId, subdivisionId), (0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)));
            if (withLimit) {
                query.limit(Number(this.limitGeoTendersDashboard));
            }
            query.orderBy((0, drizzle_orm_1.desc)(framework_1.schema.tenderTable.createdAt));
            const rows = await query;
            return rows.map((item) => this.mapRowToTender(item));
        }
        catch (err) {
            this.LOGGER.error(`Error findBySubdivisionId: ${err}`);
            return [];
        }
    }
    async upsert(tender) {
        const validatedTender = framework_1.schema.tenderTableInsertSchema.parse({
            code: tender.code,
            name: tender.name,
            description: tender.description,
            details: tender.details,
            subdivisionId: tender.subdivisionId,
        });
        const insertedTenderId = await this.db.conn
            .insert(framework_1.schema.tenderTable)
            .values({
            code: validatedTender.code,
            name: validatedTender.name,
            description: validatedTender.description,
            subdivisionId: validatedTender.subdivisionId,
            details: tender.details,
        })
            .onDuplicateKeyUpdate({
            set: {
                code: validatedTender.code,
                name: validatedTender.name,
                description: validatedTender.description,
                subdivisionId: validatedTender.subdivisionId,
                details: tender.details,
                updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            },
        })
            .$returningId()
            .then((rows) => {
            return rows[0].id;
        });
        return insertedTenderId;
    }
    async countActiveTenders() {
        this.LOGGER.log(`countActiveTenders`);
        return await this.db.conn
            .select({ count: (0, drizzle_orm_1.count)() })
            .from(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)))
            .then((rows) => {
            return rows[0].count;
        });
    }
    async getLogicalRemoveTenderIds() {
        this.LOGGER.log(`getLogicalRemoveTenderIds`);
        return await this.db.conn
            .select({ id: framework_1.schema.tenderTable.id, code: framework_1.schema.tenderTable.code, details: framework_1.schema.tenderTable.details, description: framework_1.schema.tenderTable.description })
            .from(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, false))
            .then((rows) => {
            return rows.map((row) => new domain_1.TenderTO(row.id, row.code, row.details, row.description));
        });
    }
    async updateField(tender) {
        await this.db.conn
            .update(framework_1.schema.tenderTable)
            .set({
            active: tender.active,
            subdivisionId: tender.subdivisionId,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            details: tender.detail,
            deletedAt: tender.active ? null : util_1.TenderUtil.getCurrentSystemDate(),
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tender.id))
            .execute();
    }
    async updateCloseDate(tender) {
        await this.db.conn
            .update(framework_1.schema.tenderTable)
            .set({
            closeDate: tender.closeDate,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate()
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tender.id))
            .execute();
    }
    async updateLogicalRemove(tender) {
        if (!tender.state) {
            await this.db.conn
                .update(framework_1.schema.tenderTable)
                .set({
                active: tender.state,
                deletedAt: util_1.TenderUtil.getCurrentSystemDate()
            })
                .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tender.id))
                .execute();
        }
    }
    async updateSubdivision(tender) {
        await this.db.conn
            .update(framework_1.schema.tenderTable)
            .set({
            subdivisionId: tender.subdivisionId,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate()
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tender.id))
            .execute();
    }
    selectTenderQuery() {
        return this.db.conn
            .select({
            id: framework_1.schema.tenderTable.id,
            code: framework_1.schema.tenderTable.code,
            name: framework_1.schema.tenderTable.name,
            description: framework_1.schema.tenderTable.description,
            details: framework_1.schema.tenderTable.details,
            createdAt: framework_1.schema.tenderTable.createdAt,
            updatedAt: framework_1.schema.tenderTable.updatedAt,
            closeDate: framework_1.schema.tenderTable.closeDate,
        })
            .from(framework_1.schema.tenderTable)
            .$dynamic();
    }
    mapRowToTender(row) {
        return new domain_1.Tender(row.id, row.code, row.name, row.description, row.details, row.createdAt, row.updatedAt, row.closeDate, false, row.subdivisionId ? row.subdivisionId : undefined);
    }
    mapRowToAgileTender(rows) {
        return rows.map((row) => new agile_tender_entity_1.AgileTender(row.id, row.code, row.name, row.description, row.details, row.createdAt, row.closeDate, row.isFavorite ? row.isFavorite : false, row.descriptionLocation ? row.descriptionLocation : undefined, row.amountCLP ? row.amountCLP : undefined, row.subdivisionId ? row.subdivisionId : undefined, row.updatedAt ? row.updatedAt : undefined));
    }
    async upsertAgileTender(tender) {
        const validatedTender = framework_1.schema.agileTenderTableInsertSchema.parse({
            code: tender.code,
            name: tender.name,
            closeDate: tender.closeDate,
            description: tender.description,
            descriptionLocation: tender.descriptionLocation,
            details: tender.details,
            subdivisionId: tender.subdivisionId,
            amountCLP: tender.amountCLP,
        });
        const insertedTenderId = await this.db.conn
            .insert(framework_1.schema.agileTenderTable)
            .values({
            code: validatedTender.code,
            name: validatedTender.name,
            closeDate: validatedTender.closeDate,
            description: validatedTender.description,
            descriptionLocation: validatedTender.descriptionLocation,
            details: tender.details,
            subdivisionId: validatedTender.subdivisionId,
            amountCLP: validatedTender.amountCLP,
        })
            .onDuplicateKeyUpdate({
            set: {
                code: validatedTender.code,
                name: validatedTender.name,
                closeDate: validatedTender.closeDate,
                description: validatedTender.description,
                descriptionLocation: validatedTender.descriptionLocation,
                details: tender.details,
                updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
                subdivisionId: validatedTender.subdivisionId,
                amountCLP: validatedTender.amountCLP,
            },
        })
            .$returningId();
        return insertedTenderId[0].id;
    }
    async getAgileTenderWithouthMetadata() {
        return await this.db.conn
            .select({
            id: framework_1.schema.agileTenderTable.id,
            code: framework_1.schema.agileTenderTable.code,
            name: framework_1.schema.agileTenderTable.name,
            description: framework_1.schema.agileTenderTable.description,
            details: framework_1.schema.agileTenderTable.details,
            createdAt: framework_1.schema.agileTenderTable.createdAt,
            updatedAt: framework_1.schema.agileTenderTable.updatedAt,
            closeDate: framework_1.schema.agileTenderTable.closeDate,
            subdivisionId: framework_1.schema.agileTenderTable.subdivisionId,
            descriptionLocation: framework_1.schema.agileTenderTable.descriptionLocation,
        })
            .from(framework_1.schema.agileTenderTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.agileTenderTable.active, true)))
            .limit(500)
            .then((rows) => {
            return this.mapRowToAgileTender(rows);
        });
    }
};
exports.TenderRepositoryImpl = TenderRepositoryImpl;
exports.TenderRepositoryImpl = TenderRepositoryImpl = TenderRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService,
        config_1.ConfigService])
], TenderRepositoryImpl);
//# sourceMappingURL=tender-repository-impl.js.map