import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { AgileTenderFullInfoTO } from 'src/licitaapp/application';
import { UserCompanyAgileTenderRepository } from 'src/licitaapp/application/repository/user-company-agile-tender-repository/user-company-agile-tender-repository.interface';
import { AgileTender } from 'src/licitaapp/domain';
export declare class UserCompanyAgileTenderRepositoryImpl implements UserCompanyAgileTenderRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    findTenderByUserCompanyId(userId: number, companyId: number): Promise<AgileTender[]>;
    private mapRowToAgileTender;
    getFavoriteList(userId: number): Promise<number[]>;
    getPaginatedAgileTenders(userId: number, companyId: number, page: number, pageSize: number, isFavorite: boolean): Promise<AgileTenderFullInfoTO[]>;
    saveAll(userId: number, companyId: number, tenderIds: number[], isFavorite: boolean): Promise<boolean>;
    erraseUserCompanyAgileTender(tenderAgileIds: number[]): Promise<void>;
    countActiveTendersCompany(companyId: number): Promise<number>;
}
