"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UserCompanyAgileTenderRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCompanyAgileTenderRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const util_1 = require("../../../domain/util");
let UserCompanyAgileTenderRepositoryImpl = UserCompanyAgileTenderRepositoryImpl_1 = class UserCompanyAgileTenderRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(UserCompanyAgileTenderRepositoryImpl_1.name);
    }
    async findTenderByUserCompanyId(userId, companyId) {
        this.LOGGER.log(`findTenderByUserCompanyId userId: ${userId} companyId: ${companyId}`);
        return await this.db.conn
            .select({
            id: framework_1.schema.agileTenderTable.id,
            code: framework_1.schema.agileTenderTable.code,
            name: framework_1.schema.agileTenderTable.name,
            description: framework_1.schema.agileTenderTable.description,
            details: framework_1.schema.agileTenderTable.details,
            createdAt: framework_1.schema.agileTenderTable.createdAt,
            updatedAt: framework_1.schema.agileTenderTable.updatedAt,
            closeDate: framework_1.schema.agileTenderTable.closeDate,
            subdivisionId: framework_1.schema.agileTenderTable.subdivisionId,
            descriptionLocation: framework_1.schema.agileTenderTable.descriptionLocation,
        })
            .from(framework_1.schema.agileTenderTable)
            .innerJoin(framework_1.schema.userCompanyAgileTenderTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.agileTenderId, framework_1.schema.agileTenderTable.id))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.active, true), (0, drizzle_orm_1.eq)(framework_1.schema.agileTenderTable.active, true)))
            .then((rows) => {
            return this.mapRowToAgileTender(rows);
        });
    }
    mapRowToAgileTender(rows) {
        return rows.map((row) => new domain_1.AgileTender(row.id, row.code, row.name, row.description, row.details, row.createdAt, row.closeDate, row.isFavorite ? row.isFavorite : false, row.descriptionLocation ? row.descriptionLocation : undefined, row.amountCLP ? row.amountCLP : undefined, row.subdivisionId ? row.subdivisionId : undefined, row.updatedAt ? row.updatedAt : undefined));
    }
    getFavoriteList(userId) {
        this.LOGGER.log(`getFavoriteList - userId: ${userId}`);
        return this.db.conn
            .select({
            agileTenderId: framework_1.schema.userCompanyAgileTenderTable.agileTenderId
        })
            .from(framework_1.schema.userCompanyAgileTenderTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.isFavorite, true)))
            .execute()
            .then((rows) => rows.map((row) => row.agileTenderId));
    }
    async getPaginatedAgileTenders(userId, companyId, page, pageSize, isFavorite) {
        this.LOGGER.log(`getPaginatedAgileTenders - userId: ${userId}, companyId: ${companyId}, page: ${page}, pageSize: ${pageSize}, isFavorite: ${isFavorite}`);
        const offset = (page - 1) * pageSize;
        const selectFields = {
            data: framework_1.schema.agileTenderTable.details,
            createdAt: framework_1.schema.agileTenderTable.createdAt,
            updatedAt: framework_1.schema.agileTenderTable.updatedAt,
            tenderAgileId: framework_1.schema.agileTenderTable.id,
            closeDate: framework_1.schema.agileTenderTable.closeDate,
        };
        let whereSentence = (0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.isFavorite, isFavorite), (0, drizzle_orm_1.eq)(framework_1.schema.agileTenderTable.active, true));
        const query = this.db.conn
            .select(selectFields)
            .from(framework_1.schema.agileTenderTable)
            .where(whereSentence)
            .limit(Number(pageSize))
            .offset(offset);
        query.leftJoin(framework_1.schema.userCompanyAgileTenderTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.agileTenderId, framework_1.schema.agileTenderTable.id));
        query.orderBy((0, drizzle_orm_1.asc)(framework_1.schema.agileTenderTable.closeDate));
        const rows = await query;
        if (rows.length === 0) {
            return [];
        }
        return rows.map((row) => {
            const out = row.data;
            out.general.lastUpdatedAt = row.updatedAt ? row.updatedAt : row.createdAt;
            out.general.tenderAgileId = row.tenderAgileId;
            out.general.closeDate = row.closeDate;
            return out;
        });
    }
    async saveAll(userId, companyId, tenderIds, isFavorite) {
        this.LOGGER.log(`saveAll - userId: ${userId}, companyId: ${companyId}, tenderIds: ${tenderIds} isFavorite: ${isFavorite}`);
        await this.db.conn.transaction(async (tx) => {
            for (const agileTenderId of tenderIds) {
                await tx
                    .insert(framework_1.schema.userCompanyAgileTenderTable)
                    .values({ userId, companyId, agileTenderId, isFavorite })
                    .onDuplicateKeyUpdate({
                    set: {
                        userId,
                        companyId,
                        agileTenderId,
                        isFavorite,
                        updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
                    },
                })
                    .execute();
            }
        });
        return true;
    }
    async erraseUserCompanyAgileTender(tenderAgileIds) {
        this.LOGGER.log(`erraseUserCompanyAgileTender - tenderAgileIds: ${tenderAgileIds}`);
        await this.db.conn
            .delete(framework_1.schema.userCompanyAgileTenderTable)
            .where((0, drizzle_orm_1.inArray)(framework_1.schema.userCompanyAgileTenderTable.agileTenderId, tenderAgileIds))
            .execute();
    }
    async countActiveTendersCompany(companyId) {
        return await this.db.conn
            .select({ count: (0, drizzle_orm_1.count)() })
            .from(framework_1.schema.userCompanyAgileTenderTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyAgileTenderTable.active, true)))
            .then((rows) => {
            return rows[0].count;
        });
    }
};
exports.UserCompanyAgileTenderRepositoryImpl = UserCompanyAgileTenderRepositoryImpl;
exports.UserCompanyAgileTenderRepositoryImpl = UserCompanyAgileTenderRepositoryImpl = UserCompanyAgileTenderRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], UserCompanyAgileTenderRepositoryImpl);
//# sourceMappingURL=user-company-agile-tender-repository-impl.js.map