"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UserCompanyRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCompanyRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const user_minimal_to_1 = require("../../../domain/dto/user.minimal.to");
let UserCompanyRepositoryImpl = UserCompanyRepositoryImpl_1 = class UserCompanyRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(UserCompanyRepositoryImpl_1.name);
    }
    async countActiveUser() {
        return await this.db.conn
            .select({ count: (0, drizzle_orm_1.count)() })
            .from(framework_1.schema.userTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.userTable.active, true))
            .then((rows) => {
            return rows[0].count;
        });
    }
    async countUserByCompany(companyId) {
        this.LOGGER.log(`Counting users by company: ${companyId}`);
        return await this.db.conn
            .select({ count: (0, drizzle_orm_1.count)() })
            .from(framework_1.schema.userCompanyTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.companyId, companyId)))
            .then((rows) => {
            return rows[0].count;
        });
    }
    async getInfoUserCompany(companyId) {
        this.LOGGER.log(`getInfoUserCompany companyId ${companyId}`);
        return await this.db.conn.
            select({
            userId: framework_1.schema.userTable.id,
            active: framework_1.schema.userTable.active,
            email: framework_1.schema.userTable.email,
            cellPhone: framework_1.schema.userTable.cellPhone,
            name: framework_1.schema.userTable.name,
            lastName: framework_1.schema.userTable.lastName,
        })
            .from(framework_1.schema.companyTable)
            .innerJoin(framework_1.schema.userCompanyTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.companyId, framework_1.schema.companyTable.id))
            .innerJoin(framework_1.schema.userTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.userId, framework_1.schema.userTable.id))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.companyId, companyId)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                const fullName = row.name + ' ' + (row.lastName ? row.lastName : '');
                return new user_minimal_to_1.UserMinimalTO(row.userId, fullName, row.email, row.cellPhone ? row.cellPhone : '', row.active);
            });
        });
    }
    async getUserIdsWithActiveCompany() {
        this.LOGGER.log(`getUserIdsWithActiveCompany`);
        return await this.db.conn
            .select({
            userId: framework_1.schema.userCompanyTable.userId,
        })
            .from(framework_1.schema.userCompanyTable)
            .innerJoin(framework_1.schema.companyTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.companyId, framework_1.schema.companyTable.id))
            .where((0, drizzle_orm_1.eq)(framework_1.schema.companyTable.active, true))
            .groupBy(framework_1.schema.userCompanyTable.userId)
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => row.userId);
        });
    }
    async findCompaniesByUserId(userId) {
        this.LOGGER.log(`Finding companies by user: ${userId}`);
        return await this.db.conn
            .select({
            id: framework_1.schema.companyTable.id,
            dni: framework_1.schema.companyTable.dni,
            socialReason: framework_1.schema.companyTable.socialReason,
            updatedAt: framework_1.schema.companyTable.updatedAt,
        })
            .from(framework_1.schema.userCompanyTable)
            .innerJoin(framework_1.schema.companyTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.companyId, framework_1.schema.companyTable.id))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.companyTable.active, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => new domain_1.Company(row.id, row.dni, row.socialReason));
        });
    }
    async save(userId, companyId, tx) {
        this.LOGGER.log(`Saving user company: ${userId} - ${companyId}`);
        try {
            await (tx || this.db.conn)
                .insert(framework_1.schema.userCompanyTable)
                .values({ userId, companyId });
            return true;
        }
        catch (error) {
            throw new Error(error);
        }
    }
    async deleteByUserCompany(userId, companyId, tx) {
        this.LOGGER.log(`Deleting user company: ${userId} - ${companyId}`);
        await (tx || this.db.conn)
            .delete(framework_1.schema.userCompanyTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.companyId, companyId)));
    }
    async paginationByUser(userId, page, pageSize) {
        this.LOGGER.log(`paginationByUser user ${userId} page ${page} pageSize ${pageSize}`);
        const offset = (page - 1) * pageSize;
        return await this.db.conn
            .select({
            field1: framework_1.schema.companyTable.id,
            field2: framework_1.schema.companyTable.dni,
            field3: framework_1.schema.companyTable.socialReason,
            field4: framework_1.schema.companyTable.createdAt,
            field5: framework_1.schema.companyTable.updatedAt,
        })
            .from(framework_1.schema.companyTable)
            .innerJoin(framework_1.schema.userCompanyTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.companyId, framework_1.schema.companyTable.id))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.companyTable.active, true)))
            .orderBy(framework_1.schema.companyTable.dni)
            .offset(offset)
            .limit(Number(pageSize))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                let company = new domain_1.Company(row.field1, row.field2, row.field3);
                company.updatedAt = row.field5 ? row.field5 : row.field4;
                return company;
            });
        });
    }
};
exports.UserCompanyRepositoryImpl = UserCompanyRepositoryImpl;
exports.UserCompanyRepositoryImpl = UserCompanyRepositoryImpl = UserCompanyRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], UserCompanyRepositoryImpl);
//# sourceMappingURL=user-company-repository-impl.js.map