"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UserCompanyTenderRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCompanyTenderRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const util_1 = require("../../../domain/util");
let UserCompanyTenderRepositoryImpl = UserCompanyTenderRepositoryImpl_1 = class UserCompanyTenderRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(UserCompanyTenderRepositoryImpl_1.name);
    }
    async erraseUserCompanyTender(tenderIds) {
        this.LOGGER.log(`erraseUserCompanyTender - tenderIds: ${tenderIds.length}`);
        await this.db.conn
            .delete(framework_1.schema.userCompanyTenderTable)
            .where((0, drizzle_orm_1.inArray)(framework_1.schema.userCompanyTenderTable.tenderId, tenderIds.map(t => t.tenderId)))
            .execute();
    }
    async saveAll(userId, companyId, tenderIds, source) {
        try {
            await this.db.conn.transaction(async (tx) => {
                for (const tenderId of tenderIds) {
                    await tx
                        .insert(framework_1.schema.userCompanyTenderTable)
                        .values({ userId, companyId, tenderId, source })
                        .onDuplicateKeyUpdate({
                        set: {
                            userId,
                            companyId,
                            tenderId,
                            source,
                            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
                        },
                    })
                        .execute();
                }
            });
            return true;
        }
        catch (error) {
            throw new Error(error);
        }
    }
    async updateFavoriteUserCompanyTender(userId, companyId, tenderId, isFavorite) {
        this.LOGGER.log(`updateFavoriteUserCompanyTender userId: ${userId} companyId: ${companyId} tenderId: ${tenderId} isFavorite: ${isFavorite}`);
        await this.save(userId, companyId, tenderId, 'Usuario', 'usuarios', isFavorite);
    }
    async save(userId, companyId, tenderId, source, matchResult, isFavorite = false) {
        try {
            await this.db.conn.transaction(async (tx) => {
                await tx
                    .insert(framework_1.schema.userCompanyTenderTable)
                    .values({ userId, companyId, tenderId, source, matchResult })
                    .onDuplicateKeyUpdate({
                    set: {
                        userId,
                        companyId,
                        tenderId,
                        source,
                        matchResult,
                        isFavorite,
                        updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
                    },
                })
                    .execute();
            });
            return true;
        }
        catch (error) {
            throw new Error(error);
        }
    }
    async findAllUserIdWithTenders() {
        return await this.db.conn
            .select({
            userId: framework_1.schema.userCompanyTenderTable.userId,
        })
            .from(framework_1.schema.userCompanyTenderTable)
            .innerJoin(framework_1.schema.userTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.userId, framework_1.schema.userTable.id))
            .where((0, drizzle_orm_1.eq)(framework_1.schema.userTable.active, true))
            .groupBy(framework_1.schema.userCompanyTenderTable.userId)
            .then((rows) => {
            return rows.map((row) => {
                return row.userId;
            });
        });
    }
    async findTenderByUserCompanyId(userId, companyId) {
        this.LOGGER.log(`findTenderByUserCompanyId userId: ${userId} companyId: ${companyId}`);
        return await this.db.conn
            .select()
            .from(framework_1.schema.tenderTable)
            .innerJoin(framework_1.schema.userCompanyTenderTable, (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.tenderId, framework_1.schema.tenderTable.id))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.active, true), (0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => new domain_1.Tender(row.tender.id, row.tender.code, row.tender.name, row.tender.description, row.tender.details, row.tender.createdAt, row.tender.updatedAt, row.tender.closeDate, row.user_company_tender.isFavorite, row.tender.subdivisionId, row.user_company_tender.source));
        });
    }
    async getPaginatedTenders(userId, companyId, page, pageSize, searchType, filterLabel) {
        this.LOGGER.log(`REPOSITORY getPaginatedTenders userId: ${userId} companyId: ${companyId} page: ${page} pageSize: ${pageSize} searchType: ${searchType} filterLabel: ${filterLabel}`);
        const offset = (page - 1) * pageSize;
        let output = [];
        if (searchType === 'NORMAL_TENDERS') {
            await this.db.conn
                .execute(`select tender.id, tender.code, tender.name, tender.description, tender.details, tender.created_at, tender.updated_at, user_company_tender.is_favorite
          from user_company_tender 
          LEFT join tender on tender.id = user_company_tender.tender_id
          where user_company_tender.user_id = ${userId} and 
          user_company_tender.company_id = ${+companyId} and 
          user_company_tender.source like('${filterLabel}%') and
          user_company_tender.is_favorite = false and 
          user_company_tender.active = true and tender.active = true order by tender.close_date desc limit ${pageSize} OFFSET ${offset}`)
                .then((rows) => {
                output = rows[0].map((row) => {
                    return new domain_1.Tender(row.id, row.code, row.name, row.description, row.details, row.created_at, row.updated_at, null, row.is_favorite == 0 ? false : true);
                });
            })
                .catch((err) => {
                this.LOGGER.error(`Error findByDates: ${err}`);
            });
        }
        else if (searchType === 'FAVORITE_TENDERS') {
            await this.db.conn
                .execute(`select tender.id, tender.code, tender.name, tender.description, tender.details, tender.created_at, tender.updated_at, user_company_tender.is_favorite
          from user_company_tender 
          LEFT join tender on tender.id = user_company_tender.tender_id
          where 
            user_company_tender.user_id = ${userId} and 
            user_company_tender.company_id = ${+companyId} and 
            user_company_tender.is_favorite = true and  
            user_company_tender.active = true
            AND tender.active = true ORDER BY tender.close_date DESC LIMIT ${pageSize} OFFSET ${offset}`)
                .then((rows) => {
                output = rows[0].map((row) => {
                    return new domain_1.Tender(row.id, row.code, row.name, row.description, row.details, row.created_at, row.updated_at, null, row.is_favorite == 0 ? false : true);
                });
            })
                .catch((err) => {
                this.LOGGER.error(`Error findByDates: ${err}`);
            });
        }
        else {
            await this.db.conn
                .execute(`select tender.id, tender.code, tender.name, tender.description, tender.details, tender.created_at, tender.updated_at
          FROM tender
          WHERE tender.active = true order by tender.close_date desc limit ${pageSize} OFFSET ${offset}`)
                .then((rows) => {
                output = rows[0].map((row) => {
                    return new domain_1.Tender(row.id, row.code, row.name, row.description, row.details, row.created_at, row.updated_at, null, false);
                });
            })
                .catch((err) => {
                this.LOGGER.error(`Error findByDates: ${err}`);
            });
        }
        return output;
    }
    async getHistoryTendersFavorite(userId, dateRequest) {
        this.LOGGER.log(`getHistoryTendersFavorite userId: ${userId} dateRequest: ${dateRequest}`);
        const { start, end } = util_1.TenderUtil.getDayStartAndEnd(dateRequest);
        var listTender = [];
        await this.db.conn
            .execute(`select tender.id, tender.code, tender.name, tender.description, tender.details, tender.created_at, tender.updated_at, user_company_tender.is_favorite from tender inner join 
          user_company_tender on user_company_tender.tender_id = tender.id where (user_company_tender.user_id = ${userId}
           and tender.close_date between '${start.toISOString().slice(0, 19).replace('T', ' ')}' and '${end.toISOString().slice(0, 19).replace('T', ' ')}' and 
           user_company_tender.active = true and tender.active = true and user_company_tender.is_favorite = true)`)
            .then((rows) => {
            const items = rows[0];
            listTender = items.map((row) => {
                const outObj = new domain_1.Tender(row.id, row.code, row.name, row.description, row.details, row.created_at, row.updated_at, null, row.is_favorite);
                outObj.isErrased = false;
                return outObj;
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findWithoutCity: ${err}`);
        });
        return listTender;
    }
    async getPaginatedHistoryTenders(userId, page, pageSize) {
        this.LOGGER.log(`getPaginatedHistoryTenders userId: ${userId}, page: ${page}, pageSize: ${pageSize}`);
        const offset = (page - 1) * pageSize;
        const selectFields = {
            id: framework_1.schema.userHistoryTenderTable.id,
            tenderId: framework_1.schema.userHistoryTenderTable.tenderId,
            codeTender: framework_1.schema.userHistoryTenderTable.codeTender,
            metadata: framework_1.schema.userHistoryTenderTable.metadata,
        };
        let whereSentence = (0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userHistoryTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userHistoryTenderTable.active, true));
        const query = this.db.conn
            .select(selectFields)
            .from(framework_1.schema.userHistoryTenderTable)
            .where(whereSentence)
            .limit(Number(pageSize))
            .offset(offset);
        const rows = await query;
        if (rows.length === 0) {
            return [];
        }
        return rows.map((row) => {
            const metadataOldTender = row.metadata;
            const out = new domain_1.HistoryTenderDetail();
            out.isErrased = metadataOldTender ? true : false;
            out.code = row.codeTender ? row.codeTender : '';
            out.id = row.tenderId ? row.tenderId : 0;
            if (metadataOldTender) {
                out.labelAmount = metadataOldTender.labelAmount;
                out.typeOfMoney = metadataOldTender.typeOfMoney;
                out.labelLastUpdated = metadataOldTender.labelLastUpdated;
                out.labelCloseTender = metadataOldTender.labelCloseTender;
                out.description = metadataOldTender.description;
                out.name = metadataOldTender.name;
            }
            return out;
        });
    }
    async logicalRemoveCompanyTenderUser(userId, companyId, tenderId) {
        await this.db.conn
            .update(framework_1.schema.userCompanyTenderTable)
            .set({ active: false, deletedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.userId, userId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.tenderId, tenderId)))
            .execute();
    }
    async erraseJoinCompanyTender(companyId) {
        this.LOGGER.log(`erraseJoinCompanyTender - companyId: ${companyId}`);
        await this.db.conn
            .delete(framework_1.schema.userCompanyTenderTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.isFavorite, false)))
            .execute();
    }
    async countActiveTendersCompany(companyId) {
        return await this.db.conn
            .select({ count: (0, drizzle_orm_1.count)() })
            .from(framework_1.schema.userCompanyTenderTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTenderTable.active, true)))
            .then((rows) => {
            return rows[0].count;
        });
    }
    async getUsersIdsByCompanyId(companyId) {
        this.LOGGER.log(`getUsersIdsByCompanyId companyId: ${companyId}`);
        return await this.db.conn
            .select({ userId: framework_1.schema.userCompanyTable.userId })
            .from(framework_1.schema.userCompanyTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.userCompanyTable.companyId, companyId))
            .then((rows) => {
            return rows.map((row) => row.userId);
        });
    }
};
exports.UserCompanyTenderRepositoryImpl = UserCompanyTenderRepositoryImpl;
exports.UserCompanyTenderRepositoryImpl = UserCompanyTenderRepositoryImpl = UserCompanyTenderRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], UserCompanyTenderRepositoryImpl);
//# sourceMappingURL=user-company-tender-repository-impl.js.map