import { TxType } from 'src/framework';
import { CompanyKeywordService } from 'src/licitaapp/application/service/company-keyword-service/company-keyword-service.interface';
import { CompanyKeywordRepository } from 'src/licitaapp/application/repository/company-keyword-repository/company-keyword-repository.interface';
import { Keyword } from 'src/licitaapp/domain';
export declare class CompanyKeywordServiceImpl implements CompanyKeywordService {
    private readonly companyKeywordRepository;
    private readonly LOGGER;
    constructor(companyKeywordRepository: CompanyKeywordRepository);
    findByCompanyId(companyId: number, tx?: TxType): Promise<Keyword[]>;
    deleteByCompanyAndKeywordId(companyId: number, keywordId: number, tx?: TxType): Promise<void>;
    deleteByCompanyId(companyId: number, tx?: TxType): Promise<void>;
    saveAll(companyId: number, keywordId: number[], tx?: TxType): Promise<void>;
}
