import { FwkCacheService } from 'src/framework';
import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';
import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { UserCompanyService, CompanyRepository, CompanyService, KeywordService } from 'src/licitaapp';
import { CompanyKeywordService } from 'src/licitaapp/application/service/company-keyword-service/company-keyword-service.interface';
import { TenderKeywordCategoryService } from 'src/licitaapp/application/service/tender-keyword-category-service/tender-keyword-category-service.interface';
import { UserCompanyAgileTenderService } from 'src/licitaapp/application/service/user-company-agile-tender-service/user-company-agile-tender-service.interface';
import { UserCompanyTenderService } from 'src/licitaapp/application/service/user-company-tender-service/user-company-tender-service.interface';
import { Company, CompanyFullTO, CompanyRegisterTO } from 'src/licitaapp/domain';
import { PaginationKeywordTO } from 'src/licitaapp/domain/dto/company.user.to';
import { UserPaginationTO } from 'src/licitaapp/domain/dto/user.pagination.to';
export declare class CompanyServiceImpl implements CompanyService {
    private readonly companyRepository;
    private readonly userCompanyService;
    private readonly tenderKeywordCategoryService;
    private readonly keywordService;
    private readonly userCompanyTenderService;
    private readonly userCompanyAgileTenderService;
    private readonly companyKeywordService;
    private readonly db;
    private readonly fwkCacheService;
    private readonly LOGGER;
    constructor(companyRepository: CompanyRepository, userCompanyService: UserCompanyService, tenderKeywordCategoryService: TenderKeywordCategoryService, keywordService: KeywordService, userCompanyTenderService: UserCompanyTenderService, userCompanyAgileTenderService: UserCompanyAgileTenderService, companyKeywordService: CompanyKeywordService, db: DBConfigService, fwkCacheService: FwkCacheService);
    paginationByCompanyKeyword(page: number, pageSize: number, socialReason?: string): Promise<PaginationKeywordTO[]>;
    getAllCompanyWithoutKeywords(): Promise<number[]>;
    getCompanyIdsActive(): Promise<number[]>;
    deleteByUserCompany(userId: number, companyId: number): Promise<void>;
    paginationByCompanyAdmin(page: number, pageSize: number): Promise<UserPaginationTO>;
    getCompanyIdsToRecalculateTender(): Promise<number[]>;
    getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
    updateCheckTenders(companyId: number, checkTender: boolean): Promise<boolean>;
    updateCompany(companyId: number, userId: number, updateCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    createCompany(userId: number, insertCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    findByDNI(dni: string): Promise<Company | null>;
    findById(id: number): Promise<Company | null>;
    findByIdWithFetch(id: number): Promise<CompanyFullTO | null>;
}
