"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var CompanyServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
const drizzle_provider_1 = require("../../../../framework/infrastructure/drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const user_pagination_to_1 = require("../../../domain/dto/user.pagination.to");
let CompanyServiceImpl = CompanyServiceImpl_1 = class CompanyServiceImpl {
    constructor(companyRepository, userCompanyService, tenderKeywordCategoryService, keywordService, userCompanyTenderService, userCompanyAgileTenderService, companyKeywordService, db, fwkCacheService) {
        this.companyRepository = companyRepository;
        this.userCompanyService = userCompanyService;
        this.tenderKeywordCategoryService = tenderKeywordCategoryService;
        this.keywordService = keywordService;
        this.userCompanyTenderService = userCompanyTenderService;
        this.userCompanyAgileTenderService = userCompanyAgileTenderService;
        this.companyKeywordService = companyKeywordService;
        this.db = db;
        this.fwkCacheService = fwkCacheService;
        this.LOGGER = new framework_1.PrimeLogger(CompanyServiceImpl_1.name);
    }
    async paginationByCompanyKeyword(page, pageSize, socialReason) {
        this.LOGGER.log(`Paginating companies by keyword, page: ${page}, pageSize: ${pageSize}, socialReason: ${socialReason}`);
        const data = await this.companyRepository.paginationByCompanyKeyword(page, pageSize, socialReason);
        for (const company of data) {
            company.listKeywords = await this.companyKeywordService.findByCompanyId(company.companyId);
            company.amountTenders = await this.userCompanyTenderService.countActiveTendersCompany(company.companyId);
            company.amountAgileTenders = await this.userCompanyAgileTenderService.countActiveTendersCompany(company.companyId);
        }
        return data;
    }
    getAllCompanyWithoutKeywords() {
        this.LOGGER.log('Getting all company without keywords');
        return this.companyRepository.getAllCompanyWithoutKeywords();
    }
    async getCompanyIdsActive() {
        this.LOGGER.log('Getting company ids active');
        const resultData = await this.fwkCacheService.getOrSet(framework_1.FwkCacheServiceImpl.createKey(framework_1.CacheManagerEnum.IDS_ACTIVE_COMPANIES, ["active-companies"]), async () => {
            return this.companyRepository.getCompanyIdsActive();
        });
        return resultData;
    }
    async deleteByUserCompany(userId, companyId) {
        this.LOGGER.log(`deleteByUserCompany userId ${userId} companyId ${companyId}`);
        return await this.userCompanyService.deleteByUserCompany(userId, companyId);
    }
    async paginationByCompanyAdmin(page, pageSize) {
        this.LOGGER.log(`Paginating companies by admin, page: ${page}, pageSize: ${pageSize}`);
        const output = new user_pagination_to_1.UserPaginationTO();
        output.amountUsers = await this.userCompanyService.countActiveUser();
        const companies = await this.companyRepository.paginationByCompanyAdmin(page, pageSize);
        for (const company of companies) {
            const userInfo = await this.userCompanyService.getInfoUserCompany(company.companyId);
            company.listUsers = userInfo;
            company.amountTenders = await this.userCompanyTenderService.countActiveTendersCompany(company.companyId);
        }
        output.listUsers = companies;
        return output;
    }
    async getCompanyIdsToRecalculateTender() {
        this.LOGGER.log('Getting company ids to recalculate tender');
        return await this.companyRepository.getCompanyIdsToRecalculateTender();
    }
    async getSubdivisionsByCompanyId(companyId) {
        this.LOGGER.log(`Getting subdivisions for companyId: ${companyId}`);
        return this.companyRepository.getSubdivisionsByCompanyId(companyId);
    }
    async updateCheckTenders(companyId, checkTender) {
        this.LOGGER.log(`updateCheckTenders companyId ${companyId} checkTender ${checkTender}`);
        return await this.companyRepository.updateCheckTenders(companyId, checkTender);
    }
    async updateCompany(companyId, userId, updateCompany) {
        this.LOGGER.log(`Updating company: ${updateCompany.company.id}`);
        await this.db.conn.transaction(async (tx) => {
            const companyUpdated = await this.companyRepository.update(companyId, updateCompany, tx);
            if (!companyUpdated) {
                this.LOGGER.error('problem updating company');
                throw new Error('Problem updating company');
            }
            this.LOGGER.log('Deleted relations to subdivisions');
            await this.companyRepository.deletedCompanySubdivisions(companyId, tx);
            this.LOGGER.log('Set new relations to subdivisions');
            if ((updateCompany.listSubdivisions.length) > 0) {
                this.LOGGER.log(`Saving company subdivisions for company: ${companyId} `);
                const newSubdivisions = updateCompany.listSubdivisions.filter((subdivision) => subdivision.id !== 7777);
                this.LOGGER.log(`Subdivisions: ${JSON.stringify(updateCompany.listSubdivisions)}`);
                await this.companyRepository.saveCompanySubdivisions(companyId, newSubdivisions, tx);
            }
            this.LOGGER.log(`Set new relations to keywords size: ${updateCompany.listKeywords.length}`);
            if (updateCompany.listKeywords.length > 0) {
                await this.keywordService.saveAll(updateCompany.listKeywords.map((keyword) => ({
                    ...keyword,
                    companyId: +companyId,
                    metadata: undefined,
                })), tx);
                this.LOGGER.log(`Saving keywords for company: ${companyId}`);
                const listKeywordsDB = await this.keywordService.findByCodeCategoriaMercadoPublico(updateCompany.listKeywords.map((keyword) => keyword.codeCategoriaMercadoPublico), tx);
                this.LOGGER.log(`Deleting old company keywords for company: ${companyId}`);
                await this.companyKeywordService.deleteByCompanyId(companyId, tx);
                this.LOGGER.log(`Saving new company keywords for company: ${companyId}`);
                await this.companyKeywordService.saveAll(companyId, listKeywordsDB.map((keyword) => keyword.id), tx);
            }
        });
        await this.fwkCacheService.del();
        return this.findByIdWithFetch(companyId);
    }
    async createCompany(userId, insertCompany) {
        this.LOGGER.log(`Creating company for user: ${userId}`);
        const newCompany = await this.db.conn.transaction(async (tx) => {
            var company = await this.findByDNI(insertCompany.company.dni);
            if (!company) {
                this.LOGGER.log(`Saving new company dni: ${insertCompany.company.dni}`);
                company = await this.companyRepository.save(insertCompany.company, tx);
            }
            if (!company) {
                this.LOGGER.error('Company not found');
                throw new Error('Company not found');
            }
            const companyId = company.id;
            const listSubdivisioneDB = await this.getSubdivisionsByCompanyId(company.id);
            listSubdivisioneDB.length > 0 &&
                this.LOGGER.log(`Adding more Subdivisions to company: ${company.id}`);
            if ((insertCompany?.listSubdivisions?.length ?? 0) > 0) {
                this.LOGGER.log(`Saving company subdivisions for company: ${company.id}`);
                const newSubdivisions = insertCompany.listSubdivisions.filter((subdivision) => !listSubdivisioneDB.some((existing) => existing.id === subdivision.id) && subdivision.id !== 7777);
                if (newSubdivisions.length > 0) {
                    await this.companyRepository.saveCompanySubdivisions(company.id, newSubdivisions, tx);
                }
            }
            if (insertCompany.listKeywords.length > 0) {
                await this.keywordService.saveAll(insertCompany.listKeywords.map((keyword) => ({
                    ...keyword,
                    companyId: +companyId,
                    metadata: undefined,
                })), tx);
                this.LOGGER.log(`Saving keywords for company: ${companyId}`);
                const listKeywordsDB = await this.keywordService.findByCodeCategoriaMercadoPublico(insertCompany.listKeywords.map((keyword) => keyword.codeCategoriaMercadoPublico), tx);
                this.LOGGER.log(`Deleting old company keywords for company: ${companyId}`);
                await this.companyKeywordService.deleteByCompanyId(companyId, tx);
                this.LOGGER.log(`Saving new company keywords for company: ${companyId}`);
                await this.companyKeywordService.saveAll(companyId, listKeywordsDB.map((keyword) => keyword.id), tx);
            }
            this.LOGGER.log(`Saving user-company association for user: ${userId} and company: ${company.id}`);
            await this.userCompanyService.saveUserCompany(userId, company.id, tx);
            this.LOGGER.log(`Company created successfully: ${company.id}`);
            return company;
        });
        return this.findByIdWithFetch(newCompany.id);
    }
    async findByDNI(dni) {
        this.LOGGER.log(`Finding company by DNI: ${dni}`);
        return await this.companyRepository.findByDNI(dni);
    }
    async findById(id) {
        this.LOGGER.log(`Finding company by id: ${id}`);
        return await this.fwkCacheService.getOrSet(framework_1.FwkCacheServiceImpl.createKey(framework_1.CacheManagerEnum.FIND_COMPANY_BY_ID, [id]), async () => {
            return this.companyRepository.findById(id);
        });
    }
    async findByIdWithFetch(id) {
        this.LOGGER.log(`Finding company with fetch by id: ${id}`);
        const company = await this.findById(id);
        if (!company) {
            this.LOGGER.warn(`Company not found by id: ${id}`);
            return null;
        }
        this.LOGGER.log(`Fetching keywords for company: ${company.id}`);
        const listKeywords = await this.companyKeywordService.findByCompanyId(company.id);
        this.LOGGER.log(`Fetching subdivisions for company: ${company.id}`);
        const listSubdivisions = await this.companyRepository.getSubdivisionsByCompanyId(company.id);
        this.LOGGER.log(`Company with fetch found successfully: ${company.id}`);
        return new domain_1.CompanyFullTO(company, listKeywords.map((keyword) => {
            return {
                id: keyword.id,
                value: keyword.value,
                codeCategoriaMercadoPublico: keyword.codeCategoriaMercadoPublico,
                origin: keyword.origin,
                isSelected: true,
                metadata: keyword.metadata,
            };
        }), listSubdivisions);
    }
};
exports.CompanyServiceImpl = CompanyServiceImpl;
exports.CompanyServiceImpl = CompanyServiceImpl = CompanyServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('CompanyRepository')),
    __param(1, (0, common_1.Inject)('UserCompanyService')),
    __param(2, (0, common_1.Inject)('TenderKeywordCategoryService')),
    __param(3, (0, common_1.Inject)('KeywordService')),
    __param(4, (0, common_1.Inject)('UserCompanyTenderService')),
    __param(5, (0, common_1.Inject)('UserCompanyAgileTenderService')),
    __param(6, (0, common_1.Inject)('CompanyKeywordService')),
    __param(8, (0, common_1.Inject)('FwkCacheService')),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object, Object, Object, drizzle_provider_1.DBConfigService, Object])
], CompanyServiceImpl);
//# sourceMappingURL=company-service-impl.js.map