import { TxType } from 'src/framework';
import { KeywordRepository, KeywordService } from 'src/licitaapp/application';
import { MercadoPublicoGirosRepository } from 'src/licitaapp/application/mercado-publico/mp-giros/mercado-publico-giros.repository';
import { InsertKeyword, Keyword, KeywordItem, Metadata } from 'src/licitaapp/domain';
export declare class KeywordServiceImpl implements KeywordService {
    private readonly keywordRepository;
    private readonly mpGiros;
    private readonly LOGGER;
    constructor(keywordRepository: KeywordRepository, mpGiros: MercadoPublicoGirosRepository);
    findByCodeCategoriaMercadoPublico(codeCategoriaMercadoPublico: number[], tx?: TxType | undefined): Promise<Keyword[]>;
    findKeywordsByNameList(names: string[]): Promise<number[]>;
    findAdminValues(): Promise<string[]>;
    updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;
    getAllWithouthMetadata(tx?: TxType): Promise<Keyword[]>;
    save(keyword: InsertKeyword, tx?: TxType): Promise<Keyword>;
    saveAll(keywords: InsertKeyword[], tx?: TxType): Promise<Keyword[]>;
    findByName(search: string): Promise<KeywordItem[]>;
    logicalRemove(keywordsId: number): Promise<void>;
}
