"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var KeywordServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeywordServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
const mercado_publico_giros_repository_1 = require("../../../application/mercado-publico/mp-giros/mercado-publico-giros.repository");
const domain_1 = require("../../../domain");
let KeywordServiceImpl = KeywordServiceImpl_1 = class KeywordServiceImpl {
    constructor(keywordRepository, mpGiros) {
        this.keywordRepository = keywordRepository;
        this.mpGiros = mpGiros;
        this.LOGGER = new framework_1.PrimeLogger(KeywordServiceImpl_1.name);
    }
    findByCodeCategoriaMercadoPublico(codeCategoriaMercadoPublico, tx) {
        this.LOGGER.log(`findByCodeCategoriaMercadoPublico codeCategoriaMercadoPublico: ${JSON.stringify(codeCategoriaMercadoPublico)}`);
        return this.keywordRepository.findByCodeCategoriaMercadoPublico(codeCategoriaMercadoPublico, tx);
    }
    findKeywordsByNameList(names) {
        this.LOGGER.log(`findKeywordsByNameList names: ${JSON.stringify(names)}`);
        return this.keywordRepository.findKeywordsByNameList(names);
    }
    findAdminValues() {
        this.LOGGER.log(`findAdminValues`);
        return this.keywordRepository.findAdminValues();
    }
    updateMetadata(keywordId, metadata) {
        this.LOGGER.log(`updateMetadata keywordId: ${keywordId} metadata: ${JSON.stringify(metadata)}`);
        return this.keywordRepository.updateMetadata(keywordId, metadata);
    }
    getAllWithouthMetadata(tx) {
        this.LOGGER.log(`getAllWithouthMetadata`);
        return this.keywordRepository.getAllWithouthMetadata(tx);
    }
    save(keyword, tx) {
        this.LOGGER.log(`save keyword: ${JSON.stringify(keyword)}`);
        return this.keywordRepository.save(keyword, tx);
    }
    async saveAll(keywords, tx) {
        this.LOGGER.log(`saveAll keywords: ${JSON.stringify(keywords)}`);
        const keywordsExisting = await this.keywordRepository.findByCodeCategoriaMercadoPublico(keywords.map((k) => k.codeCategoriaMercadoPublico));
        const filteredKeywords = keywords.filter((keyword) => {
            return !keywordsExisting.find((kE) => kE.codeCategoriaMercadoPublico === keyword.codeCategoriaMercadoPublico);
        });
        return this.keywordRepository.saveAll(filteredKeywords, tx);
    }
    async findByName(search) {
        this.LOGGER.log(`findByName keyword: ${search}`);
        if (search.length < 3) {
            return [];
        }
        return this.mpGiros
            .buscarGiros({ q: search })
            .then((response) => {
            if (!response || response.length === 0) {
                return [{ value: search, origin: domain_1.KeywordOrigin.USER, codeCategoriaMercadoPublico: 0 }];
            }
            else {
                return response.map((item) => ({
                    value: item.text,
                    origin: domain_1.KeywordOrigin.MERCADO_PUBLICO,
                    codeCategoriaMercadoPublico: +item.id,
                }));
            }
        })
            .catch(() => {
            return [{ value: search, origin: domain_1.KeywordOrigin.USER, codeCategoriaMercadoPublico: 0 }];
        });
    }
    async logicalRemove(keywordsId) {
        this.LOGGER.log(`logicalRemove keyword: ${keywordsId}`);
        await this.keywordRepository.logicalRemove(keywordsId);
    }
};
exports.KeywordServiceImpl = KeywordServiceImpl;
exports.KeywordServiceImpl = KeywordServiceImpl = KeywordServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('KeywordRepository')),
    __metadata("design:paramtypes", [Object, mercado_publico_giros_repository_1.MercadoPublicoGirosRepository])
], KeywordServiceImpl);
//# sourceMappingURL=keyword-service-impl.js.map