import { FwkCacheService, GeoService } from 'src/framework';
import { MatchingWordRepository } from 'src/licitaapp/application/repository/matching_word-repository/matching_word-repository.interface';
import { MatchingWordService } from 'src/licitaapp/application/service/matching_word-service/matching_word-service.interface';
import { InsertMatchingWord, MatchingWord, UpdateMatchingWord } from 'src/licitaapp/domain';
export declare class MatchingWordServiceImpl implements MatchingWordService {
    private readonly matchingWordRepository;
    private readonly fwkCacheService;
    private readonly geoService;
    private readonly LOGGER;
    constructor(matchingWordRepository: MatchingWordRepository, fwkCacheService: FwkCacheService, geoService: GeoService);
    getPagination(page: number, pageSize: number, subdivisionId?: string, wordSearch?: string): Promise<MatchingWord[]>;
    findSubdivisionIdByMatchingWords(word: string): Promise<number | null | undefined>;
    findAll(): Promise<MatchingWord[]>;
    findById(id: number): Promise<MatchingWord | null | undefined>;
    save(matchingWord: InsertMatchingWord): Promise<boolean>;
    update(matchingWord: UpdateMatchingWord): Promise<boolean>;
    delete(matchingWordId: number): Promise<boolean>;
}
