"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var MatchingWordServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchingWordServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
const app_exception_logger_1 = require("../../../../framework/infrastructure/definition/logger/app.exception.logger");
let MatchingWordServiceImpl = MatchingWordServiceImpl_1 = class MatchingWordServiceImpl {
    constructor(matchingWordRepository, fwkCacheService, geoService) {
        this.matchingWordRepository = matchingWordRepository;
        this.fwkCacheService = fwkCacheService;
        this.geoService = geoService;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(MatchingWordServiceImpl_1.name);
    }
    getPagination(page, pageSize, subdivisionId, wordSearch) {
        this.LOGGER.log(`Getting paginated matching words - page: ${page}, pageSize: ${pageSize}, subdivisionId: ${subdivisionId}, wordSearch: ${wordSearch}`);
        return this.matchingWordRepository.getPagination(page, pageSize, subdivisionId, wordSearch);
    }
    async findSubdivisionIdByMatchingWords(word) {
        if (!word || word.trim() === '') {
            return null;
        }
        this.LOGGER.log(`Finding subdivision id by matching word: ${word}`);
        const normalizeText = (text) => text
            .toLowerCase()
            .normalize('NFD')
            .replace(/[\u0300-\u036f]/g, '')
            .replace(/[^a-z0-9 ]/g, '')
            .replace('de', '')
            .replace(' y ', '');
        const records = await this.findAll();
        let output = null;
        for (const objectRecord of records) {
            for (const wordItem of objectRecord.coincidence.words) {
                if (word === wordItem ||
                    normalizeText(word).includes(normalizeText(wordItem)) ||
                    normalizeText(wordItem).includes(normalizeText(word))) {
                    output = objectRecord.subdivisionId;
                    break;
                }
                if (output)
                    break;
            }
        }
        const infoSubdivision = await this.geoService.searchSubdivisionsByName([word]);
        if (infoSubdivision) {
            output = infoSubdivision.subdivision.id;
        }
        return output;
    }
    async findAll() {
        this.LOGGER.log('Finding all matching words');
        return await this.fwkCacheService.getOrSet(framework_1.CacheManagerEnum.FIND_ALL_MATCHING_WORD, async () => {
            this.LOGGER.log(`Fetching matching words from DB`);
            return this.matchingWordRepository.findAll();
        });
    }
    async findById(id) {
        this.LOGGER.log(`Finding matching word by id: ${id}`);
        return await this.fwkCacheService.getOrSet(framework_1.FwkCacheServiceImpl.createKey(framework_1.CacheManagerEnum.FIND_ONE_MATCHING_WORD, [id]), async () => {
            return this.matchingWordRepository.findById(id);
        });
    }
    async save(matchingWord) {
        this.LOGGER.log(`Saving matching word: ${JSON.stringify(matchingWord)}`);
        return await this.matchingWordRepository.save(matchingWord).then(result => {
            this.fwkCacheService.del(framework_1.CacheManagerEnum.FIND_ALL_MATCHING_WORD);
            return result;
        });
    }
    async update(matchingWord) {
        this.LOGGER.log(`Updating matching word with id: ${matchingWord.id}`);
        return await this.matchingWordRepository.update(matchingWord).then(result => {
            this.fwkCacheService.del(framework_1.CacheManagerEnum.FIND_ALL_MATCHING_WORD);
            return result;
        });
    }
    delete(matchingWordId) {
        this.LOGGER.log(`Deleting matching word with id: ${matchingWordId}`);
        return this.matchingWordRepository.delete(matchingWordId).then(result => {
            this.fwkCacheService.del(framework_1.CacheManagerEnum.FIND_ALL_MATCHING_WORD);
            return result;
        });
    }
};
exports.MatchingWordServiceImpl = MatchingWordServiceImpl;
exports.MatchingWordServiceImpl = MatchingWordServiceImpl = MatchingWordServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('MatchingWordRepository')),
    __param(1, (0, common_1.Inject)('FwkCacheService')),
    __param(2, (0, common_1.Inject)('GeoService')),
    __metadata("design:paramtypes", [Object, Object, Object])
], MatchingWordServiceImpl);
//# sourceMappingURL=matching_word-service-impl.js.map