import { ConfigService } from '@nestjs/config';
import { FirebaseService, FwkCacheService, UserCampaignsService, UserRequestService, UserRoleService } from 'src/framework';
import { NotificationRecordService } from 'src/framework/application/service/notification-record-service/notification-record-service.interface';
import { CompanyService, UserCompanyService } from 'src/licitaapp/application';
import { ScheduleMpService } from 'src/licitaapp/application/service/schedule-mp-service/schedule-mp-service.interface';
import { TenderFetcherService } from 'src/licitaapp/application/service/tender-fetcher-service/tender-fetcher-service.interface';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { UserCompanyAgileTenderService } from 'src/licitaapp/application/service/user-company-agile-tender-service/user-company-agile-tender-service.interface';
export declare class ScheduleMpServiceImpl implements ScheduleMpService {
    private readonly configService;
    private readonly userCompanyAgileTenderService;
    private readonly tenderService;
    private readonly tenderFetcherService;
    private readonly userCampaignsService;
    private readonly notificationRecordService;
    private readonly userCompanyService;
    private readonly fwkCacheService;
    private readonly firebaseService;
    private readonly userRequestService;
    private readonly companyService;
    private readonly userRoleService;
    private readonly LOGGER;
    private readonly isCronActive;
    private hourToSearchTenders;
    private perFiveMinutes;
    private allHours;
    constructor(configService: ConfigService, userCompanyAgileTenderService: UserCompanyAgileTenderService, tenderService: TenderService, tenderFetcherService: TenderFetcherService, userCampaignsService: UserCampaignsService, notificationRecordService: NotificationRecordService, userCompanyService: UserCompanyService, fwkCacheService: FwkCacheService, firebaseService: FirebaseService, userRequestService: UserRequestService, companyService: CompanyService, userRoleService: UserRoleService);
    sendNotificationsRecords(): Promise<void>;
    mainCentralScheduleMp(): Promise<void>;
    checkFewKeywordsToCompany(): Promise<void>;
    createCampaign(hour: number, minute: number): Promise<void>;
}
