"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ScheduleMpServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduleMpServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const schedule_1 = require("@nestjs/schedule");
const framework_1 = require("../../../../framework");
const enum_definition_1 = require("../../../domain/enum/enum.definition");
const util_1 = require("../../../domain/util");
let ScheduleMpServiceImpl = ScheduleMpServiceImpl_1 = class ScheduleMpServiceImpl {
    constructor(configService, userCompanyAgileTenderService, tenderService, tenderFetcherService, userCampaignsService, notificationRecordService, userCompanyService, fwkCacheService, firebaseService, userRequestService, companyService, userRoleService) {
        this.configService = configService;
        this.userCompanyAgileTenderService = userCompanyAgileTenderService;
        this.tenderService = tenderService;
        this.tenderFetcherService = tenderFetcherService;
        this.userCampaignsService = userCampaignsService;
        this.notificationRecordService = notificationRecordService;
        this.userCompanyService = userCompanyService;
        this.fwkCacheService = fwkCacheService;
        this.firebaseService = firebaseService;
        this.userRequestService = userRequestService;
        this.companyService = companyService;
        this.userRoleService = userRoleService;
        this.LOGGER = new framework_1.PrimeLogger(ScheduleMpServiceImpl_1.name);
        this.hourToSearchTenders = [4];
        this.perFiveMinutes = [5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55];
        this.allHours = [
            6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
        ];
        this.isCronActive =
            this.configService
                .get('CRON_JOB_ENABLED', 'true')
                .toLowerCase() === 'true';
    }
    async sendNotificationsRecords() {
        if (!this.isCronActive) {
            this.LOGGER.warn('sendNotificationsRecords - Cron job is disabled');
            return;
        }
        const currentTime = util_1.TenderUtil.getCurrentSystemDate();
        const hour = currentTime.getHours();
        const minute = currentTime.getMinutes();
        this.LOGGER.log('sendNotificationsRecords - START');
        try {
            await this.firebaseService.sendAllNotificationsRecords();
            if (this.allHours.includes(hour) && minute === 30) {
                const countActiveRequests = await this.userRequestService.countActiveUserRequests();
                countActiveRequests > 0 && await this.firebaseService.notifyToAdminUsers(countActiveRequests);
            }
        }
        catch (error) {
            this.LOGGER.error(`sendNotificationsRecords - Error: ${error}`);
        }
    }
    async mainCentralScheduleMp() {
        if (!this.isCronActive) {
            this.LOGGER.warn('mainCentralScheduleMp - Cron job is disabled');
            return;
        }
        const currentTime = util_1.TenderUtil.getCurrentSystemDate();
        this.LOGGER.log(`mainCentralScheduleMp - currentTime: ${currentTime.toLocaleString('es-CL', { timeZone: util_1.TenderUtil.TIMEZONE })}`);
        this.tenderService.tenderTaskPerMinutes();
        const hour = currentTime.getHours();
        const minute = currentTime.getMinutes();
        this.LOGGER.log(`mainCentralScheduleMp - hour: ${hour}, minute: ${minute}`);
        if (this.hourToSearchTenders.includes(hour) && minute === 0) {
            let applicationLogId = await this.tenderService.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG);
            await this.tenderFetcherService.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG, applicationLogId, this.tenderFetcherService.callfetchTendersOfTheDay.bind(this.tenderFetcherService));
            applicationLogId = await this.tenderService.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG);
            await this.tenderFetcherService.logAndExecute(enum_definition_1.ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG, applicationLogId, this.tenderFetcherService.callFetchAgileTenders.bind(this.tenderFetcherService));
            applicationLogId = await this.tenderService.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.FETCH_JOIN_AGILE_TENDER_LOG);
            await this.tenderFetcherService.logAndExecute(enum_definition_1.ApplicationTypeEnum.FETCH_JOIN_AGILE_TENDER_LOG, applicationLogId, this.tenderFetcherService.joinAgileTenderWithKeywords.bind(this.tenderFetcherService));
        }
        if (this.perFiveMinutes.includes(minute)) {
            this.tenderService.tenderTaskEvery5Minutes();
        }
        if (hour === 0 && minute === 22) {
            this.LOGGER.log('mainCentralScheduleMp - Executing daily tasks');
            this.tenderService.tenderTaskPerDay();
            this.checkFewKeywordsToCompany();
        }
        if (hour % 2 !== 0 && minute === 7) {
            this.LOGGER.log('mainCentralScheduleMp - Executing tasks every 2 hours');
            this.tenderService.tenderTaskBy2Hour();
        }
        if (hour % 2 == 0 && minute === 18) {
            this.LOGGER.log('mainCentralScheduleMp - Executing tasks every 2 hours pairs');
            const { end } = util_1.TenderUtil.getDayStartAndEnd(util_1.TenderUtil.getCurrentSystemDate());
            const listTenderAgileIds = await this.tenderService.findByCloseDateAgileTender(util_1.TenderUtil.subtractDays(end, 1));
            this.userCompanyAgileTenderService.erraseUserCompanyAgileTender(listTenderAgileIds);
            this.tenderService.erraseAgileOldTenders(listTenderAgileIds);
            await this.fwkCacheService.del();
        }
        if (this.allHours.includes(hour) && minute === 17) {
            this.LOGGER.log('mainCentralScheduleMp - Executing tasks every hour');
            this.tenderService.tenderTaskByHour();
        }
        this.LOGGER.log(`mainCentralScheduleMp - Running CAMPAIGN at ${hour}:${minute}`);
        this.createCampaign(hour, minute);
    }
    async checkFewKeywordsToCompany() {
        this.LOGGER.log('checkFewKeywordsToCompany - START');
        const companiesToNotify = await this.companyService.getAllCompanyWithoutKeywords();
        const adminIds = await this.userRoleService.getAdminUserIds();
        const notificationsArray = [];
        for (const companyId of companiesToNotify) {
            const companyData = await this.companyService.findById(companyId);
            const listUser = await this.userCompanyService.getInfoUserCompany(companyId);
            for (const userData of listUser) {
                this.LOGGER.log(`createCampaign - Creating notification for user with id: ${userData.userId}`);
                notificationsArray.push({
                    userId: userData.userId,
                    title: `Añade más Rubros`,
                    defaultMessage: 'Tienes muy pocos Rubros asociados a tu empresa...',
                    active: true,
                });
            }
            adminIds.forEach((adminId) => {
                notificationsArray.push({
                    userId: adminId,
                    title: `Asistencia de Rubros`,
                    defaultMessage: `Admin: La empresa ${companyData?.socialReason} tiene 1 Rubro asociado.`,
                    active: true,
                    isAdmin: true,
                });
            });
        }
        notificationsArray.length > 0 &&
            (await this.notificationRecordService.saveAll(notificationsArray));
        this.LOGGER.log('checkFewKeywordsToCompany - END');
    }
    async createCampaign(hour, minute) {
        const campaings = await this.userCampaignsService.getActiveCampaigns();
        if (!campaings || campaings.length === 0) {
            this.LOGGER.warn('createCampaign - No active campaigns found');
            return;
        }
        this.LOGGER.log(`createCampaign - Found ${campaings.length} active campaigns`);
        for (const campaign of campaings) {
            const daysOfWeek = campaign.dayOfWeek.split('-').map(Number);
            if (!daysOfWeek.includes(util_1.TenderUtil.getCurrentSystemDate().getDay())) {
                this.LOGGER.log(`createCampaign - Skipping campaign ${campaign.id} for day ${campaign.dayOfWeek}`);
                continue;
            }
            this.LOGGER.log(`createCampaign - Processing campaign ${campaign.id}`);
            if (!campaign.defHour || !campaign.defMinute) {
                this.LOGGER.warn(`createCampaign - Campaign ${campaign.id} does not have a valid time set`);
                continue;
            }
            else {
                this.LOGGER.warn(`Campaign ${campaign.id} has time set to ${campaign.defHour}:${campaign.defMinute} compare with ${hour}:${minute}`);
                if (campaign.defHour == hour && campaign.defMinute == minute) {
                    this.LOGGER.log(`createCampaign - Creating campaign for user with id: ${campaign.id}`);
                    const activeUserIds = await this.userCompanyService.getUserIdsWithActiveCompany();
                    const notificationsArray = [];
                    for (const userID of activeUserIds) {
                        this.LOGGER.log(`createCampaign - Creating notification for user with id: ${userID}`);
                        notificationsArray.push({
                            userId: userID,
                            title: campaign.title,
                            defaultMessage: campaign.defaultMessage,
                            active: true,
                        });
                    }
                    notificationsArray.length > 0 &&
                        (await this.notificationRecordService.saveAll(notificationsArray));
                }
            }
        }
    }
};
exports.ScheduleMpServiceImpl = ScheduleMpServiceImpl;
__decorate([
    (0, schedule_1.Cron)(schedule_1.CronExpression.EVERY_DAY_AT_10PM, {
        name: 'sendNotificationsRecords',
        timeZone: util_1.TenderUtil.TIMEZONE,
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ScheduleMpServiceImpl.prototype, "sendNotificationsRecords", null);
__decorate([
    (0, schedule_1.Cron)(schedule_1.CronExpression.EVERY_MINUTE, {
        name: 'mainCentralScheduleMp',
        timeZone: util_1.TenderUtil.TIMEZONE,
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ScheduleMpServiceImpl.prototype, "mainCentralScheduleMp", null);
exports.ScheduleMpServiceImpl = ScheduleMpServiceImpl = ScheduleMpServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, common_1.Inject)('UserCompanyAgileTenderService')),
    __param(2, (0, common_1.Inject)('TenderService')),
    __param(3, (0, common_1.Inject)('TenderFetcherService')),
    __param(4, (0, common_1.Inject)('UserCampaignsService')),
    __param(5, (0, common_1.Inject)('NotificationRecordService')),
    __param(6, (0, common_1.Inject)('UserCompanyService')),
    __param(7, (0, common_1.Inject)('FwkCacheService')),
    __param(8, (0, common_1.Inject)('FirebaseService')),
    __param(9, (0, common_1.Inject)('UserRequestService')),
    __param(10, (0, common_1.Inject)('CompanyService')),
    __param(11, (0, common_1.Inject)('UserRoleService')),
    __metadata("design:paramtypes", [config_1.ConfigService, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object])
], ScheduleMpServiceImpl);
//# sourceMappingURL=schedule-mp-service-impl.js.map