import { ConfigService } from '@nestjs/config';
import { FwkCacheService } from 'src/framework';
import { AgileTenderFullInfoTO, CompanyService, DetailAgileTenderTO, LicitacionesQueryParams, LicitacionesResponse, UserCompanyService } from 'src/licitaapp/application';
import { MercadoPublicoRepository } from 'src/licitaapp/application/mercado-publico/mp.repository';
import { ApplicationLogService } from 'src/licitaapp/application/service/application-log-service/application-log-service.interface';
import { CompanyKeywordService } from 'src/licitaapp/application/service/company-keyword-service/company-keyword-service.interface';
import { MatchingWordService } from 'src/licitaapp/application/service/matching_word-service/matching_word-service.interface';
import { TenderFetcherService } from 'src/licitaapp/application/service/tender-fetcher-service/tender-fetcher-service.interface';
import { TenderKeywordCategoryService } from 'src/licitaapp/application/service/tender-keyword-category-service/tender-keyword-category-service.interface';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { UserCompanyAgileTenderService } from 'src/licitaapp/application/service/user-company-agile-tender-service/user-company-agile-tender-service.interface';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';
export declare class TenderFetcherServiceImpl implements TenderFetcherService {
    private readonly configService;
    private readonly mercadoPublicoAPI;
    private readonly tenderService;
    private readonly userCompanyAgileTenderService;
    private readonly applicationLogService;
    private readonly matchingWordService;
    private readonly tenderKeywordCategoryService;
    private readonly companyService;
    private readonly userCompanyService;
    private readonly companyKeywordService;
    private readonly fwkCacheService;
    private readonly LOGGER;
    static readonly TIMEZONE = "America/Santiago";
    private readonly maxRetries;
    private readonly retryInterval;
    private readonly fetchFromDaysAgo;
    private readonly enabled;
    constructor(configService: ConfigService, mercadoPublicoAPI: MercadoPublicoRepository, tenderService: TenderService, userCompanyAgileTenderService: UserCompanyAgileTenderService, applicationLogService: ApplicationLogService, matchingWordService: MatchingWordService, tenderKeywordCategoryService: TenderKeywordCategoryService, companyService: CompanyService, userCompanyService: UserCompanyService, companyKeywordService: CompanyKeywordService, fwkCacheService: FwkCacheService);
    joinAgileTenderWithKeywords(applicationLogId: number, companyId?: number, userID?: number): Promise<string>;
    callFetchAgileTenders(applicationLogId: number): Promise<string>;
    logAndExecute(type: ApplicationTypeEnum, applicationLogId: number, action: (applicationLogId: number) => Promise<string>): Promise<void>;
    fetchTendersWithRetry(args: LicitacionesQueryParams): Promise<LicitacionesResponse | undefined>;
    processTenders(args: LicitacionesQueryParams): Promise<boolean>;
    private getCodesFromItems;
    callfetchTendersOfTheDay(applicationLogId: number): Promise<string>;
    fetchTendersOfTheDay(ddmmyyyy?: string): Promise<boolean | undefined>;
    private getAgileTenders;
    addDetailAgileTender(data: DetailAgileTenderTO | undefined): string;
    saveAgileTender(tenderInfo: AgileTenderFullInfoTO): Promise<number>;
    private processAgileTender;
    syncTenders(): Promise<void>;
}
