"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TenderFetcherServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderFetcherServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const moment = require("moment-timezone");
const framework_1 = require("../../../../framework");
const mp_repository_1 = require("../../../application/mercado-publico/mp.repository");
const domain_1 = require("../../../domain");
const enum_definition_1 = require("../../../domain/enum/enum.definition");
const util_1 = require("../../../domain/util");
const util_2 = require("util");
let TenderFetcherServiceImpl = TenderFetcherServiceImpl_1 = class TenderFetcherServiceImpl {
    constructor(configService, mercadoPublicoAPI, tenderService, userCompanyAgileTenderService, applicationLogService, matchingWordService, tenderKeywordCategoryService, companyService, userCompanyService, companyKeywordService, fwkCacheService) {
        this.configService = configService;
        this.mercadoPublicoAPI = mercadoPublicoAPI;
        this.tenderService = tenderService;
        this.userCompanyAgileTenderService = userCompanyAgileTenderService;
        this.applicationLogService = applicationLogService;
        this.matchingWordService = matchingWordService;
        this.tenderKeywordCategoryService = tenderKeywordCategoryService;
        this.companyService = companyService;
        this.userCompanyService = userCompanyService;
        this.companyKeywordService = companyKeywordService;
        this.fwkCacheService = fwkCacheService;
        this.LOGGER = new framework_1.PrimeLogger(TenderFetcherServiceImpl_1.name);
        this.maxRetries = this.configService.get('TENDER_FETCHER_MAX_RETRIES', 2);
        this.retryInterval = this.configService.get('TENDER_FETCHER_RETRY_INTERVAL', 1000);
        this.fetchFromDaysAgo = this.configService.get('TENDER_FETCHER_FETCH_FROM_DAYS_AGO', 90);
        this.enabled =
            this.configService.get('TENDER_FETCHER_ENABLED', 'false') === 'true';
    }
    async joinAgileTenderWithKeywords(applicationLogId, companyId, userID) {
        var messageTxt = `ApplicationLogId: ${applicationLogId} - inicio`;
        const companyIds = companyId ? [companyId] : await this.companyService.getCompanyIdsActive();
        for (const currentCompanyId of companyIds) {
            messageTxt += ` Procesando companyId: ${currentCompanyId}.`;
            const keywordsCompany = await this.companyKeywordService.findByCompanyId(currentCompanyId);
            messageTxt += ` Encontradas ${keywordsCompany.length} palabras clave.`;
            for (const keyword of keywordsCompany) {
                messageTxt += ` Procesando keyword: ${keyword.codeCategoriaMercadoPublico}.`;
                const resultMatchAgileTenderCompany = await this.mercadoPublicoAPI.matchAgileKeyword(keyword.codeCategoriaMercadoPublico);
                messageTxt += ` Encontrados ${resultMatchAgileTenderCompany.payload ? resultMatchAgileTenderCompany.payload.pageSize * resultMatchAgileTenderCompany.payload.pageCount : 0} licitaciones ágil para la palabra clave: ${keyword.codeCategoriaMercadoPublico}.`;
                if (resultMatchAgileTenderCompany.payload && resultMatchAgileTenderCompany.payload.pageSize > 0) {
                    for (const tender of resultMatchAgileTenderCompany.payload.resultados) {
                        messageTxt += ` Asociando licitación ágil código: ${tender.codigo} - company ${currentCompanyId} - rubroMatch: ${keyword.id}.`;
                        const fullDetail = await this.mercadoPublicoAPI.licitacionAgilDetail(tender.codigo);
                        const tenderAgileId = await this.saveAgileTender({
                            general: tender,
                            licitacionAgilDetail: fullDetail,
                        });
                        for (const informacion of fullDetail?.productos_solicitados || []) {
                            await this.tenderKeywordCategoryService.saveAgileTenderCategory(tenderAgileId, `${keyword.codeCategoriaMercadoPublico}`, informacion.descripcion);
                        }
                        if (userID) {
                            this.userCompanyAgileTenderService.saveAll(userID, currentCompanyId, [tenderAgileId], false);
                        }
                        else {
                            const userInfo = await this.userCompanyService.getInfoUserCompany(currentCompanyId);
                            for (const user of userInfo) {
                                this.userCompanyAgileTenderService.saveAll(user.userId, currentCompanyId, [tenderAgileId], false);
                            }
                        }
                    }
                }
            }
        }
        this.LOGGER.log(messageTxt);
        return Promise.resolve(messageTxt);
    }
    async callFetchAgileTenders(applicationLogId) {
        var messageTxt = `ApplicationLogId: ${applicationLogId} - inicio`;
        messageTxt += await this.getAgileTenders();
        return Promise.resolve(messageTxt);
    }
    async logAndExecute(type, applicationLogId, action) {
        this.LOGGER.log(`logAndExecute - type: ${type}, applicationLogId: ${applicationLogId}`);
        const startTime = Date.now();
        try {
            const message = await action(applicationLogId);
            const duration = Date.now() - startTime;
            await this.applicationLogService.updateState(applicationLogId, 10, `Duración: ${duration / 1000} s. ${message}.`);
        }
        catch (error) {
            const duration = Date.now() - startTime;
            this.LOGGER.error(`logAndExecute - ${type} - Error: ${error}`);
            await this.applicationLogService.updateState(applicationLogId, 9, util_1.TenderUtil.evalTextLarge(`Duración: ${duration / 1000} s. Error: ${(0, util_2.inspect)(error)}.`));
        }
    }
    async fetchTendersWithRetry(args) {
        const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
        for (let attempt = 1; attempt <= this.maxRetries; attempt++) {
            try {
                return await this.mercadoPublicoAPI.licitaciones(args);
            }
            catch (error) {
                throw error;
                await delay(attempt * this.retryInterval);
            }
        }
    }
    async processTenders(args) {
        this.LOGGER.debug(`Fetching tenders with args: ${JSON.stringify(args)}`);
        const startTime = Date.now();
        let messageTxt = 'Iniciado a las ' + util_1.TenderUtil.getCurrentSystemDate().toLocaleTimeString();
        const applicationLogId = await this.applicationLogService.save({
            userName: 'SYSTEM',
            statusTypeId: 8,
            detail: messageTxt,
            type: enum_definition_1.ApplicationTypeEnum.SEARCH_TENDERS_MERCADO_PUBLICO_LOG,
        });
        try {
            const tenders = await this.mercadoPublicoAPI.licitacionesListadoDiarioGeneral(args.fecha);
            messageTxt += ` - Licitaciones encontradas: ${tenders?.Cantidad || 0}`;
            if (tenders && tenders.Cantidad > 0) {
                let processed = 0;
                this.LOGGER.debug(`Fetched ${tenders.Cantidad} tenders. Processing...`);
                for (const tender of tenders.Listado) {
                    processed++;
                    this.LOGGER.debug(`Tender: ${tender.Nombre}, codigo ${tender.CodigoExterno}`);
                    messageTxt += ` - Procesando licitación código: ${tender.CodigoExterno} (${processed}/${tenders.Cantidad})`;
                    try {
                        const codeDetails = await this.mercadoPublicoAPI.licitacionesDetalleGeneral(tender.CodigoExterno);
                        if (codeDetails?.Listado) {
                            for (const tenderDetails of codeDetails.Listado) {
                                const trace = `Upserting tender: ${tenderDetails.CodigoExterno} processed ${processed}/${tenders.Cantidad} tiempo transcurrido: ${(Date.now() - startTime) / 1000} s.`;
                                this.LOGGER.debug(trace);
                                await this.applicationLogService.updateState(applicationLogId, 8, `${trace}. Trabajando...`);
                                const idTender = await this.tenderService.upsert({
                                    code: tenderDetails.CodigoExterno,
                                    name: tenderDetails.Nombre,
                                    description: tenderDetails.Descripcion,
                                    details: tenderDetails,
                                    isFavorite: false,
                                });
                                const codesKeywords = this.getCodesFromItems(tenderDetails);
                                for (const codeKeyword of codesKeywords) {
                                    await this.tenderKeywordCategoryService.saveNormalTenderCategory(idTender, codeKeyword, tenderDetails.Descripcion);
                                }
                            }
                        }
                    }
                    catch (error) {
                        const duration = Date.now() - startTime;
                        messageTxt += `Duración: ${duration / 1000} s. Error: ${(0, util_2.inspect)(error)}.`;
                        await this.applicationLogService.updateState(applicationLogId, 9, messageTxt);
                        this.LOGGER.error(`Error processing tenders for code ${tender.CodigoExterno} processed ${processed}/${tenders.Cantidad}`);
                        continue;
                    }
                }
                messageTxt += `procesados ${processed}/${tenders.Cantidad} tiempo transcurrido: ${(Date.now() - startTime) / 1000} s.`;
                await this.applicationLogService.updateState(applicationLogId, 10, messageTxt);
            }
            else {
                messageTxt += ' - No se encontraron licitaciones.';
                this.LOGGER.debug(`No tenders found for args: ${JSON.stringify(args)}`);
            }
        }
        catch (error) {
            const duration = Date.now() - startTime;
            messageTxt += `Duración: ${duration / 1000} s. Error: ${(0, util_2.inspect)(error)}.`;
            this.applicationLogService.updateState(applicationLogId, 9, messageTxt);
            this.LOGGER.error(`Error processing tenders for args: ${JSON.stringify(args)}`);
            return false;
        }
        this.LOGGER.debug('Finished processing tenders');
        return true;
    }
    getCodesFromItems(tenderDetails) {
        return tenderDetails.Items.Listado.map(item => {
            return item.CodigoCategoria;
        });
    }
    async callfetchTendersOfTheDay(applicationLogId) {
        var messageTxt = `ApplicationLogId: ${applicationLogId} - inicio`;
        await this.fetchTendersOfTheDay();
        return messageTxt;
    }
    async fetchTendersOfTheDay(ddmmyyyy) {
        if (!this.enabled) {
            this.LOGGER.log('Tender fetcher is disabled, skipping daily fetch.');
            return;
        }
        const now = moment().tz(TenderFetcherServiceImpl_1.TIMEZONE);
        const today = now.format('DDMMYYYY');
        const todayInWords = now.format('dddd, MMMM Do YYYY');
        this.LOGGER.debug(`Fetching tenders of the day ${todayInWords} (${TenderFetcherServiceImpl_1.TIMEZONE})...`);
        return await this.processTenders({ fecha: ddmmyyyy || today });
    }
    async getAgileTenders() {
        if (!this.enabled) {
            this.LOGGER.log('Tender fetcher is disabled, skipping agile tenders fetch.');
            return 'Tender fetcher is disabled, skipping agile tenders fetch.';
        }
        const now = moment().tz(TenderFetcherServiceImpl_1.TIMEZONE);
        const tomorrow = now.add(1, 'day').format('YYYY-MM-DD');
        const lastMonth = moment().tz(TenderFetcherServiceImpl_1.TIMEZONE).subtract(30, 'days').format('YYYY-MM-DD');
        const todayInWords = now.format('dddd, MMMM Do YYYY');
        this.LOGGER.debug(`Fetching tenders of the day ${todayInWords} (${TenderFetcherServiceImpl_1.TIMEZONE})...`);
        let messageTxt = `Fetching agile tenders from ${lastMonth} to ${tomorrow} (${TenderFetcherServiceImpl_1.TIMEZONE})...`;
        const firstPageInfo = await this.processAgileTender({ initDate: lastMonth, endDate: tomorrow, page: 1 });
        this.LOGGER.debug(`Saving first page results...`);
        const fullDetail = firstPageInfo && await this.mercadoPublicoAPI.licitacionAgilDetail(firstPageInfo.payload.resultados[0].codigo);
        const tenderAgileId = firstPageInfo && await this.saveAgileTender({
            general: firstPageInfo.payload.resultados[0],
            licitacionAgilDetail: fullDetail,
        });
        if (tenderAgileId) {
            for (const informacion of fullDetail?.productos_solicitados || []) {
                await this.tenderKeywordCategoryService.saveAgileTenderCategory(tenderAgileId, `${informacion.codigo_producto}`, informacion.descripcion);
            }
        }
        if (!firstPageInfo) {
            this.LOGGER.debug('No agile tenders found for today.');
            return 'No agile tenders found for today.';
        }
        messageTxt += ` Found ${firstPageInfo.payload.pageCount} pages.`;
        const totalPages = firstPageInfo?.payload.pageCount || 0;
        let resultPage;
        for (let page = 2; page <= totalPages; page++) {
            this.LOGGER.debug(`Processing page ${page} of ${totalPages}`);
            resultPage = await this.processAgileTender({ initDate: lastMonth, endDate: tomorrow, page });
            this.LOGGER.debug(`Saving page ${page} results...`);
            if (!resultPage) {
                this.LOGGER.debug(`No agile tenders found on page ${page}.`);
                continue;
            }
            messageTxt += ` Cargadas ${resultPage.payload.resultados.length} licitaciones.`;
            for (const tender of resultPage.payload.resultados) {
                const fullDetail = await this.mercadoPublicoAPI.licitacionAgilDetail(tender.codigo);
                const tenderAgileIdDB = await this.saveAgileTender({
                    general: tender,
                    licitacionAgilDetail: fullDetail,
                });
                if (tenderAgileIdDB) {
                    for (const informacion of fullDetail?.productos_solicitados || []) {
                        await this.tenderKeywordCategoryService.saveAgileTenderCategory(tenderAgileIdDB, `${informacion.codigo_producto}`, informacion.descripcion);
                    }
                }
            }
        }
        messageTxt += ` Processed ${totalPages} pages.`;
        await this.fwkCacheService.del();
        return messageTxt;
    }
    addDetailAgileTender(data) {
        let outText = data ? 'Productos:\n' : '';
        if (data && data.productos_solicitados && data.productos_solicitados.length > 0) {
            for (const producto of data.productos_solicitados) {
                outText = outText.concat(`- ${producto.nombre}\n`);
            }
        }
        return outText;
    }
    async saveAgileTender(tenderInfo) {
        const tender = new domain_1.InsertAgileTender();
        tender.code = tenderInfo.general.codigo;
        tender.name = tenderInfo.general.nombre;
        tender.description = `Disponible: ${util_1.TenderUtil.convertToMillions(tenderInfo.general.monto_disponible)} ${tenderInfo.general.moneda}\n${this.addDetailAgileTender(tenderInfo.licitacionAgilDetail)}`;
        tender.descriptionLocation = tenderInfo.general.organismo ? tenderInfo.general.organismo : '';
        tender.closeDate = moment.tz(tenderInfo.general.fecha_cierre, TenderFetcherServiceImpl_1.TIMEZONE).toDate();
        tender.details = tenderInfo;
        tender.createdAt = moment.tz(tenderInfo.general.fecha_publicacion, TenderFetcherServiceImpl_1.TIMEZONE).toDate();
        tender.subdivisionId = await this.matchingWordService.findSubdivisionIdByMatchingWords(tenderInfo.general.organismo);
        tender.amountCLP = tenderInfo.general.monto_disponible_CLP;
        return await this.tenderService.upsertAgileTender(tender);
    }
    async processAgileTender(args) {
        this.LOGGER.debug(`Fetching agile tenders with args: ${JSON.stringify(args)}`);
        const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
        for (let attempt = 1; attempt <= 3; attempt++) {
            try {
                return await this.mercadoPublicoAPI.licitacionesAgiles(args);
            }
            catch (error) {
                if (attempt === 3) {
                    this.LOGGER.error(`Error fetching agile tenders with args: ${JSON.stringify(args)} - ${(0, util_2.inspect)(error)}`);
                }
                await delay(attempt * this.retryInterval);
            }
        }
    }
    async syncTenders() {
        if (!this.enabled) {
            return;
        }
        this.LOGGER.debug(`Fetching tenders of the last ${this.fetchFromDaysAgo} days...`);
        const today = moment().tz(TenderFetcherServiceImpl_1.TIMEZONE);
        for (let i = 0; i < this.fetchFromDaysAgo; i++) {
            const date = today.subtract(i, 'days').format('DDMMYYYY');
            await this.processTenders({ fecha: date });
        }
    }
};
exports.TenderFetcherServiceImpl = TenderFetcherServiceImpl;
TenderFetcherServiceImpl.TIMEZONE = 'America/Santiago';
exports.TenderFetcherServiceImpl = TenderFetcherServiceImpl = TenderFetcherServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'MercadoPublicoRepository'))),
    __param(2, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'TenderService'))),
    __param(3, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'UserCompanyAgileTenderService'))),
    __param(4, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'ApplicationLogService'))),
    __param(5, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'MatchingWordService'))),
    __param(6, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'TenderKeywordCategoryService'))),
    __param(7, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'CompanyService'))),
    __param(8, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'UserCompanyService'))),
    __param(9, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'CompanyKeywordService'))),
    __param(10, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'FwkCacheService'))),
    __metadata("design:paramtypes", [config_1.ConfigService,
        mp_repository_1.MercadoPublicoRepository, Object, Object, Object, Object, Object, Object, Object, Object, Object])
], TenderFetcherServiceImpl);
//# sourceMappingURL=tender-fetcher-service-impl.js.map