"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TenderKeywordCategoryServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderKeywordCategoryServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
let TenderKeywordCategoryServiceImpl = TenderKeywordCategoryServiceImpl_1 = class TenderKeywordCategoryServiceImpl {
    constructor(tenderKeywordCategoryRepository) {
        this.tenderKeywordCategoryRepository = tenderKeywordCategoryRepository;
        this.LOGGER = new framework_1.PrimeLogger(TenderKeywordCategoryServiceImpl_1.name);
    }
    async findAllByWordFilter(wordFilter, returnNormalTender) {
        this.LOGGER.log(`findAllByWordFilter wordFilter: ${wordFilter} returnNormalTender: ${returnNormalTender}`);
        let results = [];
        for (const word of wordFilter) {
            const partialResults = await this.tenderKeywordCategoryRepository.findAllByWordFilter(word, returnNormalTender);
            results = results.concat(partialResults);
        }
        return Array.from(new Set(results));
    }
    findAllByCodeMercadoPublico(codeMercadoPublico, returnNormalTender) {
        this.LOGGER.log(`findAllByCodeMercadoPublico codeMercadoPublico: ${JSON.stringify(codeMercadoPublico)} returnNormalTender: ${returnNormalTender}`);
        return this.tenderKeywordCategoryRepository.findAllByCodeMercadoPublico(codeMercadoPublico, returnNormalTender);
    }
    saveAgileTenderCategory(tenderId, codeMercadoPublico, itemDescription) {
        this.LOGGER.log(`saveAgileTenderCategory tenderId: ${tenderId} codeMercadoPublico: ${JSON.stringify(codeMercadoPublico)}`);
        return this.tenderKeywordCategoryRepository.saveAgileTenderCategory(tenderId, codeMercadoPublico, itemDescription);
    }
    saveNormalTenderCategory(tenderId, codeMercadoPublico, itemDescription) {
        this.LOGGER.log(`saveNormalTenderCategory tenderId: ${tenderId} codeMercadoPublico: ${JSON.stringify(codeMercadoPublico)}`);
        return this.tenderKeywordCategoryRepository.saveNormalTenderCategory(tenderId, codeMercadoPublico, itemDescription);
    }
    upsert(tender) {
        this.LOGGER.log(`upsert tender: ${JSON.stringify(tender)}`);
        return this.tenderKeywordCategoryRepository.upsert(tender);
    }
};
exports.TenderKeywordCategoryServiceImpl = TenderKeywordCategoryServiceImpl;
exports.TenderKeywordCategoryServiceImpl = TenderKeywordCategoryServiceImpl = TenderKeywordCategoryServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('TenderKeywordCategoryRepository')),
    __metadata("design:paramtypes", [Object])
], TenderKeywordCategoryServiceImpl);
//# sourceMappingURL=tender-keyword-category-service-impl.js.map