import { HttpService } from '@nestjs/axios';
import { ConfigService } from '@nestjs/config';
import { FirebaseService, FwkCacheService, GeoService, User, UserRequestService, UserService } from 'src/framework';
import { NotificationRecordService } from 'src/framework/application/service/notification-record-service/notification-record-service.interface';
import { AgileTenderFullInfoTO, CompanyService, KeywordService, TenderRepository, UserCompanyService } from 'src/licitaapp/application';
import { ApplicationLogService } from 'src/licitaapp/application/service/application-log-service/application-log-service.interface';
import { CompanyKeywordService } from 'src/licitaapp/application/service/company-keyword-service/company-keyword-service.interface';
import { HistoryTenderService } from 'src/licitaapp/application/service/history-tender-service/history-tender-service.interface';
import { MatchWordsService } from 'src/licitaapp/application/service/match-words-service/match-words-service.interface';
import { TenderFetcherService } from 'src/licitaapp/application/service/tender-fetcher-service/tender-fetcher-service.interface';
import { TenderKeywordCategoryService } from 'src/licitaapp/application/service/tender-keyword-category-service/tender-keyword-category-service.interface';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { UserCompanyAgileTenderService } from 'src/licitaapp/application/service/user-company-agile-tender-service/user-company-agile-tender-service.interface';
import { UserCompanyTenderService } from 'src/licitaapp/application/service/user-company-tender-service/user-company-tender-service.interface';
import { Tender, DashboardTO, Licitacion, HistoryTender, InsertTender, HistoryTenderDetail, InsertAgileTender, AgileTender, MinimalToEditAgileTender, UpdateMinimalToEditAgileTender, PaginationNormalTenderTO, GeneralDataInfoTO } from 'src/licitaapp/domain';
import { PaginationAgileTenderTO } from 'src/licitaapp/domain/dto/pagination-agile-tender.to';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';
export declare class TenderServiceImpl implements TenderService {
    private readonly tenderRepository;
    private readonly companyService;
    private readonly companyKeywordService;
    private readonly userHistoryTenderService;
    private readonly matchWordsService;
    private readonly userCompanyTenderRepository;
    private readonly userCompanyAgileTenderService;
    private readonly notificationRecordService;
    private readonly geoService;
    private readonly configService;
    private readonly httpService;
    private readonly firebaseService;
    private readonly keywordService;
    private readonly userService;
    private readonly applicationLogService;
    private readonly userCompanyService;
    private readonly userRequestService;
    private readonly fwkCacheService;
    private readonly tenderFetcherService;
    private readonly tenderKeywordCategoryService;
    private readonly LOGGER;
    private readonly maxTextRetries;
    private readonly textApiKey;
    private readonly textApiUrl;
    private readonly textApiSecondKey;
    private readonly tenderLimitDays;
    constructor(tenderRepository: TenderRepository, companyService: CompanyService, companyKeywordService: CompanyKeywordService, userHistoryTenderService: HistoryTenderService, matchWordsService: MatchWordsService, userCompanyTenderRepository: UserCompanyTenderService, userCompanyAgileTenderService: UserCompanyAgileTenderService, notificationRecordService: NotificationRecordService, geoService: GeoService, configService: ConfigService, httpService: HttpService, firebaseService: FirebaseService, keywordService: KeywordService, userService: UserService, applicationLogService: ApplicationLogService, userCompanyService: UserCompanyService, userRequestService: UserRequestService, fwkCacheService: FwkCacheService, tenderFetcherService: TenderFetcherService, tenderKeywordCategoryService: TenderKeywordCategoryService);
    getUserRequestService(): UserRequestService;
    countActiveTenders(): Promise<number>;
    createGeneralDataQuery(): Promise<GeneralDataInfoTO>;
    getNormalTenderAdminPaginated(page: number, pageSize: number, order: string, filter: string): Promise<PaginationNormalTenderTO[]>;
    updateMinimalAgileTender(dataAgiletender: UpdateMinimalToEditAgileTender): Promise<void>;
    getAgileTenderMinimalToEditById(agileTendrId: number): Promise<MinimalToEditAgileTender | undefined>;
    getAgileTenderById(agileTenderId: number): Promise<AgileTender | null | undefined>;
    getAgileTenderAdminPaginated(page: number, pageSize: number, order: string, filter: string): Promise<PaginationAgileTenderTO[]>;
    getAgileTenderWithouthMetadata(): Promise<AgileTender[]>;
    getFirebaseService(): FirebaseService;
    erraseAgileOldTenders(agileTenderIds: number[]): Promise<void>;
    findByCloseDateAgileTender(endDate: Date): Promise<number[]>;
    getAgileTenderPaginated(page: number, pageSize: number, typeSearch: string, companyId: number, userId: number): Promise<AgileTenderFullInfoTO[]>;
    upsertAgileTender(tender: InsertAgileTender): Promise<number>;
    erraseOldTenders(): Promise<string>;
    tenderTaskPerDay(): Promise<void>;
    getListTenderHistory(userId: number): Promise<HistoryTender[]>;
    logicalRemoveCompanyTenderUser(userId: number, companyId: number, tenderId: number): Promise<void>;
    updateFavoriteUserCompanytender(userId: number, companyId: number, tenderId: number, isFavorite: boolean): Promise<void>;
    upsert(tender: InsertTender): Promise<number>;
    tenderTaskByHour(): Promise<void>;
    logAndExecute(type: ApplicationTypeEnum, applicationLogId: number, action: (applicationLogId: number) => Promise<string>): Promise<void>;
    checkTenderFavoritesToClose(applicationLogId: number): Promise<string>;
    checkNewTendersUserCompany(applicationLogId: number): Promise<string>;
    tenderTaskBy2Hour(): Promise<void>;
    createApplicationLogID(type: ApplicationTypeEnum): Promise<number>;
    tenderTaskEvery5Minutes(): Promise<void>;
    checkTenderSubdivision(applicationLogId: number): Promise<string>;
    private isPrime;
    checkCloseDate(applicationLogId: number): Promise<string>;
    checkMetadataKeywords(applicationLogId: number): Promise<string>;
    checkTenderWithCloseDate(applicationLogId: number): Promise<string>;
    tenderTaskPerMinutes(): Promise<void>;
    createDashboardCompany(companyId: number, userIds: number[]): Promise<void>;
    joinNormalTenderWithKeywords(applicationLogId: number, userId: number, companyId: number): Promise<string>;
    private getDataFromMetadata;
    searchTenderToUserCompanyWithSubdivision(companyId: number, userId: number): Promise<void>;
    reviewTenderStatus(applicationLogId: number): Promise<string>;
    reviewTendersInfo(action: ApplicationTypeEnum): Promise<void>;
    private createResponseTenderMetadata;
    sendEmailSumaryToAdmin(applicationLogId: number): Promise<string>;
    private createRequestTextTender;
    evalStateTender(detail: Licitacion): boolean;
    private findSubdivision;
    private normalizeString;
    getTenderByCode(code: string, userId?: number): Promise<Tender | undefined>;
    addTenderByCodeToCompany(code: string, companyId: number): Promise<string>;
    generateInfoDashboard(user: User, companyId: number): Promise<DashboardTO>;
    getPaginatedTenders(userId: number, companyId: number, page: number, pageSize: number, searchType: string, filterLabel: string): Promise<Tender[]>;
    getPaginatedHistoryTenders(userId: number, page: number, pageSize: number): Promise<HistoryTenderDetail[]>;
    private evalResultsMatch;
    private getWordsFromMetadata;
    private getListOfWordsMetada;
    fetchRazorMetadata(textToEval: string, secondKey?: boolean): Promise<any>;
    recalculteTender(applicationLogId: number): Promise<string>;
}
