"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TenderServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderServiceImpl = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const rxjs_1 = require("rxjs");
const framework_1 = require("../../../../framework");
const domain_1 = require("../../../domain");
const enum_definition_1 = require("../../../domain/enum/enum.definition");
const util_1 = require("../../../domain/util");
const util_2 = require("util");
let TenderServiceImpl = TenderServiceImpl_1 = class TenderServiceImpl {
    constructor(tenderRepository, companyService, companyKeywordService, userHistoryTenderService, matchWordsService, userCompanyTenderRepository, userCompanyAgileTenderService, notificationRecordService, geoService, configService, httpService, firebaseService, keywordService, userService, applicationLogService, userCompanyService, userRequestService, fwkCacheService, tenderFetcherService, tenderKeywordCategoryService) {
        this.tenderRepository = tenderRepository;
        this.companyService = companyService;
        this.companyKeywordService = companyKeywordService;
        this.userHistoryTenderService = userHistoryTenderService;
        this.matchWordsService = matchWordsService;
        this.userCompanyTenderRepository = userCompanyTenderRepository;
        this.userCompanyAgileTenderService = userCompanyAgileTenderService;
        this.notificationRecordService = notificationRecordService;
        this.geoService = geoService;
        this.configService = configService;
        this.httpService = httpService;
        this.firebaseService = firebaseService;
        this.keywordService = keywordService;
        this.userService = userService;
        this.applicationLogService = applicationLogService;
        this.userCompanyService = userCompanyService;
        this.userRequestService = userRequestService;
        this.fwkCacheService = fwkCacheService;
        this.tenderFetcherService = tenderFetcherService;
        this.tenderKeywordCategoryService = tenderKeywordCategoryService;
        this.LOGGER = new framework_1.PrimeLogger(TenderServiceImpl_1.name);
        this.textApiKey = this.configService.get('TEXTRAZOR_API_KEY');
        this.textApiSecondKey = this.configService.get('TEXTRAZOR_API_SECOND_KEY');
        this.textApiUrl = this.configService.get('TEXTRAZOR_API_URL');
        this.maxTextRetries = this.configService.get('TEXTRAZOR_MAX_RETRIES', 5);
        this.tenderLimitDays = this.configService.get('TENDERS_LIMIT_DAYS', '5');
    }
    getUserRequestService() {
        return this.userRequestService;
    }
    async countActiveTenders() {
        this.LOGGER.log(`Counting active tenders`);
        return await this.fwkCacheService.getOrSet(framework_1.CacheManagerEnum.COUNT_ACTIVE_TENDERS, async () => {
            this.LOGGER.log(`Counting active tenders from DB`);
            return this.tenderRepository.countActiveTenders();
        });
    }
    createGeneralDataQuery() {
        this.LOGGER.log(`createGeneralDataQuery`);
        return this.tenderRepository.createGeneralDataQuery();
    }
    async getNormalTenderAdminPaginated(page, pageSize, order, filter) {
        this.LOGGER.log(`getNormalTenderAdminPaginated - page: ${page}, pageSize: ${pageSize}, order: ${order}, filter: ${filter}`);
        const subdivisionList = await this.geoService.findSubdivisionsByCountryCode('CL');
        const result = await this.tenderRepository.getNormalTenderAdminPaginated(page, pageSize, order, filter);
        return result.map(tender => {
            const subdivision = subdivisionList.find(s => s.id === tender.subdivisionId);
            return {
                ...tender,
                subdivisionName: subdivision ? subdivision.name : null,
            };
        });
    }
    updateMinimalAgileTender(dataAgiletender) {
        this.LOGGER.log(`updateMinimalAgileTender - agileTenderId: ${dataAgiletender}`);
        return this.tenderRepository.updateMinimalAgileTender(dataAgiletender);
    }
    getAgileTenderMinimalToEditById(agileTendrId) {
        this.LOGGER.log(`getAgileTenderMinimalToEditById - agileTendrId: ${agileTendrId}`);
        return this.tenderRepository.getAgileTenderMinimalToEditById(agileTendrId);
    }
    getAgileTenderById(agileTenderId) {
        this.LOGGER.log(`getAgileTenderById - agileTenderId: ${agileTenderId}`);
        return this.tenderRepository.getAgileTenderById(agileTenderId);
    }
    getAgileTenderAdminPaginated(page, pageSize, order, filter) {
        this.LOGGER.log(`getAgileTenderAdminPaginated - page: ${page}, pageSize: ${pageSize}, order: ${order}, filter: ${filter}`);
        return this.tenderRepository.getAgileTenderAdminPaginated(page, pageSize, order, filter);
    }
    getAgileTenderWithouthMetadata() {
        this.LOGGER.log(`getAgileTenderWithouthMetadata`);
        return this.tenderRepository.getAgileTenderWithouthMetadata();
    }
    getFirebaseService() {
        return this.firebaseService;
    }
    erraseAgileOldTenders(agileTenderIds) {
        this.LOGGER.warn(`erraseAgileOldTenders - START`);
        return this.tenderRepository.erraseAgileOldTenders(agileTenderIds);
    }
    findByCloseDateAgileTender(endDate) {
        this.LOGGER.log(`findByCloseDateAgileTender - endDate: ${endDate}`);
        return this.tenderRepository.findByCloseDateAgileTender(endDate);
    }
    async getAgileTenderPaginated(page, pageSize, typeSearch, companyId, userId) {
        this.LOGGER.log(`getAgileTenderPaginated - page: ${page}, pageSize: ${pageSize}, typeSearch: ${typeSearch}, companyId: ${companyId} userId: ${userId}`);
        const listSubdivisionByCompany = await this.companyService.getSubdivisionsByCompanyId(companyId);
        return this.tenderRepository.getAgileTenderPaginated(page, pageSize, typeSearch, listSubdivisionByCompany.map(s => s.id), companyId, userId);
    }
    upsertAgileTender(tender) {
        this.LOGGER.log(`upsert agile tender - code: ${tender.code}`);
        return this.tenderRepository.upsertAgileTender(tender);
    }
    async erraseOldTenders() {
        this.LOGGER.warn(`erraseOldTenders - START`);
        const idsTendersLogicalRemove = await this.tenderRepository.getLogicalRemoveTenderIds();
        this.LOGGER.warn(`erraseOldTenders - idsTendersLogicalRemove size: ${idsTendersLogicalRemove.length}`);
        const chunkSize = 500;
        for (let i = 0; i < idsTendersLogicalRemove.length; i += chunkSize) {
            const chunk = idsTendersLogicalRemove.slice(i, i + chunkSize);
            await this.userRequestService.erraseUserRequests(chunk);
            for (const tenderInfo of chunk) {
                await this.userHistoryTenderService.erraseUserHistoryTender(tenderInfo);
            }
            await this.userCompanyTenderRepository.erraseUserCompanyTender(chunk);
            await this.notificationRecordService.erraseNotificationRecordsByTender(chunk.map(t => t.tenderId));
            await this.tenderRepository.erraseByListId(chunk.map(t => t.tenderId));
        }
        return 'true';
    }
    async tenderTaskPerDay() {
        this.LOGGER.warn(`tenderTaskPerDay - START`);
        let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG);
        await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG, applicationLogId, this.checkTenderWithCloseDate.bind(this));
        this.LOGGER.log(`tenderTaskPerDay - init erraseOldTenders`);
        applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_ERRASE_OLD_TENDERS_LOG);
        await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_ERRASE_OLD_TENDERS_LOG, applicationLogId, this.erraseOldTenders.bind(this));
        this.LOGGER.log(`tenderTaskPerDay - end erraseOldTenders`);
    }
    async getListTenderHistory(userId) {
        this.LOGGER.log(`LIST HISTORY_TENDER - userId: ${userId}`);
        return await this.userHistoryTenderService.getListTenderHistory(userId);
    }
    async logicalRemoveCompanyTenderUser(userId, companyId, tenderId) {
        this.LOGGER.log(`logicalRemoveCompanyTenderUser userId ${userId} companyId ${companyId} tenderId ${tenderId}`);
        return await this.userCompanyTenderRepository.logicalRemoveCompanyTenderUser(userId, companyId, tenderId);
    }
    async updateFavoriteUserCompanytender(userId, companyId, tenderId, isFavorite) {
        this.LOGGER.log(`updateFavoriteUserCompanytender - userId: ${userId}, companyId: ${companyId}, tenderId: ${tenderId}, isFavorite: ${isFavorite}`);
        return await this.userCompanyTenderRepository.updateFavoriteUserCompanyTender(userId, companyId, tenderId, isFavorite);
    }
    async upsert(tender) {
        this.LOGGER.log(`upsert tender - code: ${tender.code}`);
        return await this.tenderRepository.upsert(tender);
    }
    async tenderTaskByHour() {
        this.LOGGER.warn(`checkTenderByHour - START`);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG);
    }
    async logAndExecute(type, applicationLogId, action) {
        this.LOGGER.log(`logAndExecute - type: ${type}, applicationLogId: ${applicationLogId}`);
        const startTime = Date.now();
        try {
            const message = await action(applicationLogId);
            const duration = Date.now() - startTime;
            await this.applicationLogService.updateState(applicationLogId, 10, `Duración: ${duration / 1000} s. ${message}.`);
        }
        catch (error) {
            const duration = Date.now() - startTime;
            this.LOGGER.error(`logAndExecute - ${type} - Error: ${error}`);
            await this.applicationLogService.updateState(applicationLogId, 9, util_1.TenderUtil.evalTextLarge(`Duración: ${duration / 1000} s. Error: ${(0, util_2.inspect)(error)}.`));
        }
    }
    async checkTenderFavoritesToClose(applicationLogId) {
        this.LOGGER.log(`checkTenderFavoritesToClose - START`);
        const arrayDaysToClose = this.tenderLimitDays.split('-');
        const messageTxt = `checkTenderFavoritesToClose - applicationLogId: ${applicationLogId} - arrayDaysToClose: ${arrayDaysToClose}`;
        this.LOGGER.log(`checkTenderFavoritesToClose - arrayDaysToClose: ${arrayDaysToClose}`);
        const usersIds = await this.userCompanyTenderRepository.findAllUserIdWithTenders();
        let daterequest;
        for (const dateStr of arrayDaysToClose) {
            daterequest = util_1.TenderUtil.subtractDays(util_1.TenderUtil.getSystemDateDDMMYYYY(), (+dateStr) * -1);
            messageTxt.concat(`. Processing date: ${daterequest.toLocaleDateString('es-CL', { day: '2-digit', month: '2-digit', year: 'numeric' })}`);
            for (const userId of usersIds) {
                const tenders = await this.userCompanyTenderRepository.getHistoryTendersFavorite(userId, daterequest);
                messageTxt.concat(`. Processing userId: ${userId} - tenders size: ${tenders.length}`);
                for (const tender of tenders) {
                    const notificationsArray = [];
                    notificationsArray.push({
                        userId: userId,
                        title: `Licitación favorita por cerrar`,
                        defaultMessage: `Licitación ${tender.code} favorita por cerrar en ${dateStr} día(s)`,
                        active: true,
                        tenderId: tender.id,
                        amountGeo: tenders.length,
                    });
                    notificationsArray.length > 0 && await this.notificationRecordService.saveAll(notificationsArray);
                }
                await this.firebaseService.groupNotifications(userId);
            }
        }
        this.LOGGER.log(`checkTenderFavoritesToClose - END`);
        return messageTxt;
    }
    async checkNewTendersUserCompany(applicationLogId) {
        let systemHour = util_1.TenderUtil.getCurrentSystemDate();
        let messageTxt = `ApplicationLogId: ${applicationLogId} - START - systemHour: ${systemHour.getHours()}`;
        this.LOGGER.warn(`checkPerQuarterActions - applicationLogId: ${applicationLogId} - START - systemHour: ${systemHour.getHours()}`);
        if (systemHour.getHours() >= 8 && systemHour.getHours() <= 20) {
            this.LOGGER.warn(`Eval checkNewTenders8AM`);
            try {
                const companyIds = await this.companyService.getCompanyIdsActive();
                messageTxt = messageTxt.concat(`. Checking tender to ${companyIds.length} companies`);
                for (const companyId of companyIds) {
                    messageTxt = messageTxt.concat('. Loading new tenders to companyId: ' + companyId);
                    const infoUsers = await this.userCompanyService.getInfoUserCompany(companyId);
                    messageTxt = messageTxt.concat('. Users to notify: ' + infoUsers.length);
                    for (const infoUser of infoUsers) {
                        messageTxt = await this.joinNormalTenderWithKeywords(applicationLogId, infoUser.userId, companyId);
                    }
                }
            }
            catch (error) {
                this.LOGGER.error(`checkNewTendersUserCompany - fail - Error: ${error}`);
                throw error;
            }
        }
        return messageTxt;
    }
    async tenderTaskBy2Hour() {
        this.LOGGER.warn(`checkTenderBy2Hour - START`);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG);
    }
    async createApplicationLogID(type) {
        const applicationLogId = await this.applicationLogService.save({
            userName: 'SYSTEM',
            statusTypeId: 8,
            detail: 'Iniciado a las ' + util_1.TenderUtil.getCurrentSystemDate().toLocaleTimeString(),
            type,
        });
        return applicationLogId;
    }
    async tenderTaskEvery5Minutes() {
        this.LOGGER.warn(`tenderTaskPer5Minutes - START`);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG);
        this.LOGGER.warn(`tenderTaskPer5Minutes - END`);
    }
    async checkTenderSubdivision(applicationLogId) {
        const tendersWihoutCity = await this.tenderRepository.findWithoutSubdivision();
        var messageTxt = `ApplicationLogId: ${applicationLogId} - Licitaciones sin ciudades: ${tendersWihoutCity.length}`;
        if (tendersWihoutCity.length === 0) {
            this.LOGGER.log(`checkSubdivisionTender - No tenders without city`);
            return messageTxt;
        }
        const listCities = await this.geoService.findAdmdivisionsByCountry('CL');
        const listSubdivisionDB = await this.geoService.findSubdivisionsByCountryCode('CL');
        this.LOGGER.log(`checkSubdivisionTender - listCities size: ${listCities.length}`);
        for (const tenderDetails of tendersWihoutCity) {
            const detail = tenderDetails.details;
            detail.JustificacionPublicidad = '';
            messageTxt = messageTxt.concat(`. Procesando licitación: ${tenderDetails.id} - ${tenderDetails.code}`);
            this.tenderRepository.updateSubdivision({
                id: tenderDetails.id,
                subdivisionId: await this.findSubdivision(listCities, detail, listSubdivisionDB)
            });
        }
        messageTxt = messageTxt.concat(`. Busqueda de ciudades en licitaciones finalizada.`);
        return messageTxt;
    }
    isPrime(num) {
        if (num < 2)
            return false;
        for (let i = 2; i <= Math.sqrt(num); i++) {
            if (num % i === 0)
                return false;
        }
        return true;
    }
    async checkCloseDate(applicationLogId) {
        const initTime = util_1.TenderUtil.getCurrentSystemDate().getTime();
        this.LOGGER.warn(`checkCloseDate - START`);
        const tendersWihoutCloseDate = await this.tenderRepository.findWithoutCloseDate();
        let messageTxt = `ApplicationLogId: ${applicationLogId} - Cantidad de Licitaciones sin fecha (Cierre) informada: ${tendersWihoutCloseDate.length}`;
        if (tendersWihoutCloseDate.length === 0) {
            this.LOGGER.log(`checkCloseDate - No tenders without city`);
            return messageTxt;
        }
        this.LOGGER.log(`checkCloseDate - listTenders size: ${tendersWihoutCloseDate.length}`);
        for (const tenderDetails of tendersWihoutCloseDate) {
            messageTxt = messageTxt.concat(`. Procesando licitación: ${tenderDetails.id} - ${tenderDetails.code}`);
            const detail = tenderDetails.details;
            detail.JustificacionPublicidad = '';
            this.tenderRepository.updateCloseDate({
                id: tenderDetails.id,
                closeDate: detail.Fechas.FechaCierre ? new Date(detail.Fechas.FechaCierre) : null
            });
        }
        this.LOGGER.warn(`checkCloseDate - END - time ${util_1.TenderUtil.getCurrentSystemDate().getTime() - initTime} ms`);
        return messageTxt;
    }
    async checkMetadataKeywords(applicationLogId) {
        const initTime = util_1.TenderUtil.getCurrentSystemDate().getTime();
        const listKeywordsToUpdate = await this.keywordService.getAllWithouthMetadata();
        var messageTxt = `ApplicationLogId: ${applicationLogId} - Tamaño lista a actualizar Keywords: ${listKeywordsToUpdate.length}`;
        this.LOGGER.debug(`checkMetadataKeywords - listKeywordsToUpdate size: ${listKeywordsToUpdate.length}`);
        if (listKeywordsToUpdate.length === 0) {
            this.LOGGER.debug(`checkMetadataKeywords - No keywords without metadata`);
            return messageTxt;
        }
        for (const keyword of listKeywordsToUpdate) {
            this.LOGGER.debug(`checkMetadataKeywords - keyword: ${keyword.value}`);
            try {
                const metadata = await this.fetchRazorMetadata(keyword.value);
                await this.keywordService.updateMetadata(keyword.id, this.createResponseTenderMetadata(metadata));
                messageTxt = messageTxt.concat(`. Keyword ID: ${keyword.id} actualizado con éxito`);
            }
            catch (error) {
                this.LOGGER.error(`checkMetadataKeywords - Metadata Keyword id ${keyword.id} error: ${error}`);
                throw {
                    message: `Fallo al actualizar metadata de la keyword: ${keyword.id} - ${keyword.value}`,
                    error,
                };
            }
        }
        this.LOGGER.debug(`checkMetadataKeywords - time ${util_1.TenderUtil.getCurrentSystemDate().getTime() - initTime} ms`);
        return messageTxt;
    }
    async checkTenderWithCloseDate(applicationLogId) {
        const { end } = util_1.TenderUtil.getDayStartAndEnd(util_1.TenderUtil.getCurrentSystemDate());
        const listTenderToDelete = await this.tenderRepository.findByCloseDate(util_1.TenderUtil.subtractDays(end, 1));
        var messageTxt = `ApplicationLogId: ${applicationLogId} - fecha: ${util_1.TenderUtil.subtractDays(end, 1)} Cantidad de Licitaciones vencidas el día de ayer: ${listTenderToDelete.length}`;
        for (const tenderDetails of listTenderToDelete) {
            messageTxt = messageTxt.concat(`. licitación: ${tenderDetails.id} - ${tenderDetails.code} Eliminada`);
            this.LOGGER.log(`logicalRemoveByCloseDate - tender to delete: ${tenderDetails.id}`);
            this.tenderRepository.logicalRemove(tenderDetails.id);
        }
        return messageTxt;
    }
    async tenderTaskPerMinutes() {
        const usage = process.memoryUsage();
        this.LOGGER.debug(`MEMORY IN USE: RSS=${usage.rss / 1024 / 1024} MB, HEAP=${usage.heapUsed / 1024 / 1024} MB`);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG);
    }
    async createDashboardCompany(companyId, userIds) {
        for (const userId of userIds) {
            this.joinNormalTenderWithKeywords(0, userId, companyId);
            this.tenderFetcherService.joinAgileTenderWithKeywords(0, companyId, userId);
        }
    }
    async joinNormalTenderWithKeywords(applicationLogId, userId, companyId) {
        var messageTxt = `ApplicationLogId: ${applicationLogId} - inicio`;
        const keywordsCompany = await this.companyKeywordService.findByCompanyId(companyId);
        messageTxt += ` Encontrados ${keywordsCompany.length} palabras clave company.`;
        const dataKeywordCategory = await this.tenderKeywordCategoryService.findAllByCodeMercadoPublico(keywordsCompany.map(kc => kc.codeCategoriaMercadoPublico), true);
        messageTxt += ` Encontradas ${dataKeywordCategory.length} categorías de mercado público compras normales.`;
        let wordsList = [];
        keywordsCompany.forEach(kc => {
            if (kc.origin != domain_1.KeywordOrigin.MERCADO_PUBLICO) {
                const dataFromMetadata = this.getDataFromMetadata(kc.metadata);
                wordsList = wordsList.concat(dataFromMetadata);
                wordsList.push(kc.value);
            }
        });
        const dataKeywordCategoryFilterLike = await this.tenderKeywordCategoryService.findAllByWordFilter(wordsList, true);
        messageTxt += ` Encontradas ${dataKeywordCategoryFilterLike.length} filtro directo en compras normales.`;
        await Promise.all([
            this.userCompanyTenderRepository.saveAll(userId, companyId, dataKeywordCategory, 'Coincidencia por Rubro'),
            this.userCompanyTenderRepository.saveAll(userId, companyId, dataKeywordCategoryFilterLike, 'Coincidencia por Palabra')
        ]);
        this.LOGGER.log(messageTxt);
        return messageTxt;
    }
    getDataFromMetadata(metadata) {
        if (metadata && metadata.words) {
            let result = [];
            for (let i = 0; i < metadata.words.length; i++) {
                const wordE = metadata.words[i];
                if (wordE.partOfSpeech === 'NOUN') {
                    if (i > 0 && metadata.words[i - 1].partOfSpeech === 'ADJ') {
                        result.push(wordE.stem + ' ' + metadata.words[i - 1].stem);
                    }
                    if (i < metadata.words.length - 1 && metadata.words[i + 1].partOfSpeech === 'ADJ') {
                        result.push(wordE.stem + ' ' + metadata.words[i + 1].stem);
                    }
                }
            }
            this.LOGGER.debug(`getDataFromMetadata - result size: ${result}`);
            return result;
        }
        return [];
    }
    async searchTenderToUserCompanyWithSubdivision(companyId, userId) {
        const listSubdivisionByCompany = await this.companyService.getSubdivisionsByCompanyId(companyId);
        const notificationsArray = [];
        for (const subdivision of listSubdivisionByCompany) {
            this.LOGGER.log(`searchTenderToUserCompany - subdivision: ${subdivision.name} to user: ${userId} company: ${companyId}`);
            const listTenderBySubdivision = await this.tenderRepository.findBySubdivisionId(subdivision.id, true);
            this.LOGGER.log(`searchTenderToUserCompany - subdivision: ${subdivision.id} 
        tenders: ${listTenderBySubdivision ? listTenderBySubdivision.length : 0}`);
            if (listTenderBySubdivision && listTenderBySubdivision.length > 0) {
                this.userCompanyTenderRepository.saveAll(userId, companyId, listTenderBySubdivision.map(tender => tender.id), `Cerca en ${subdivision.name}`);
                notificationsArray.push({
                    userId: userId,
                    title: `Encontradas por Ubicación`,
                    defaultMessage: (`Encontradas ${listTenderBySubdivision.length} licitaciones en ${subdivision.name}`.length > 255) ?
                        `Encontradas ${listTenderBySubdivision.length} licitaciones en ${subdivision.name}`.substring(0, 255) :
                        `Encontradas ${listTenderBySubdivision.length} licitaciones en ${subdivision.name}`,
                    active: true,
                    subdivisionId: subdivision.id,
                    amountGeo: listTenderBySubdivision.length,
                });
                this.LOGGER.warn(`Save success to user-company-tender user: ${userId} company: ${companyId} subdivision ${subdivision.id}`);
            }
        }
        notificationsArray.length > 0 && await this.notificationRecordService.saveAll(notificationsArray);
    }
    async reviewTenderStatus(applicationLogId) {
        const { start, end } = util_1.TenderUtil.getDayStartAndEnd(util_1.TenderUtil.getCurrentSystemDate());
        this.LOGGER.log(`ReviewTendersInfo - start: ${start} end: ${end}`);
        const tenders = await this.tenderRepository.findByDatesUpset(start, end);
        this.LOGGER.log(`ReviewTendersInfo - tenders size: ${tenders.length}`);
        var messageTxt = `ApplicationLogId: ${applicationLogId} - tramo horario: ${start} - ${end} - Licitaciones a revisar si ha cambiado su estado: ${tenders.length}`;
        for (const tenderDetails of tenders) {
            const detail = tenderDetails.details;
            const isActive = this.evalStateTender(detail);
            this.tenderRepository.updateLogicalRemove({
                id: tenderDetails.id,
                state: isActive
            });
        }
        messageTxt = messageTxt.concat(`. Revisión de estado de licitaciones finalizada.`);
        return messageTxt;
    }
    async reviewTendersInfo(action) {
        this.LOGGER.warn(`ReviewTendersInfo - START - action: ${action}`);
        const initTime = util_1.TenderUtil.getCurrentSystemDate().getTime();
        this.LOGGER.warn(`ReviewTendersInfo - parcial time ${util_1.TenderUtil.getCurrentSystemDate().getTime() - initTime} ms`);
        if (action === enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG, applicationLogId, this.reviewTenderStatus.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG, applicationLogId, this.checkCloseDate.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG, applicationLogId, this.checkTenderSubdivision.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG, applicationLogId, this.checkTenderWithCloseDate.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG, applicationLogId, this.sendEmailSumaryToAdmin.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG, applicationLogId, this.checkMetadataKeywords.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG, applicationLogId, this.checkTenderFavoritesToClose.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG, applicationLogId, this.firebaseService.sendDailyEmailSumary.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG, applicationLogId, this.checkNewTendersUserCompany.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG, applicationLogId, this.recalculteTender.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG, applicationLogId, this.erraseOldTenders.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG);
            await this.tenderFetcherService.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG, applicationLogId, this.tenderFetcherService.callfetchTendersOfTheDay.bind(this.tenderFetcherService));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG);
            await this.tenderFetcherService.logAndExecute(enum_definition_1.ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG, applicationLogId, this.tenderFetcherService.callFetchAgileTenders.bind(this.tenderFetcherService));
        }
        this.LOGGER.warn(`ReviewTendersInfo - tenders updated END - time ${util_1.TenderUtil.getCurrentSystemDate().getTime() - initTime} ms`);
    }
    createResponseTenderMetadata(metadata) {
        let responseMetadata = new domain_1.Metadata();
        this.LOGGER.log(`createResponseTenderMetadata - EVAL SENTENCES WORDS`);
        if (metadata.response.sentences) {
            responseMetadata.words = [];
            for (const sentence of metadata.response.sentences) {
                for (const word of sentence.words) {
                    responseMetadata.words.push(new domain_1.Word(word.position, word.startingPos, word.endingPos, word.stem, word.token, word.partOfSpeech));
                }
            }
        }
        this.LOGGER.log(`createResponseTenderMetadata - EVAL COURSE TOPISC`);
        if (metadata.response.coarseTopics) {
            responseMetadata.coarseTopics = [];
            for (const coarseTopic of metadata.response.coarseTopics) {
                responseMetadata.coarseTopics.push(new domain_1.CoarseTopics(coarseTopic.label, coarseTopic.score));
            }
        }
        this.LOGGER.log(`createResponseTenderMetadata - EVAL TOPICS`);
        if (metadata.response.topics) {
            responseMetadata.topics = [];
            for (const topic of metadata.response.topics) {
                responseMetadata.topics.push(new domain_1.Topics(topic.label, topic.score));
            }
        }
        this.LOGGER.log(`createResponseTenderMetadata - EVAL ENTITIES`);
        if (metadata.response.entities) {
            responseMetadata.entities = [];
            for (const entity of metadata.response.entities) {
                responseMetadata.entities.push(new domain_1.EntityInfo(entity.entityId, entity.type, entity.confidenceScore));
            }
        }
        return responseMetadata;
    }
    async sendEmailSumaryToAdmin(applicationLogId) {
        this.LOGGER.log(`sendEmailSumaryToAdmin - START`);
        return await this.firebaseService.sendEmailSumaryToAdmin(applicationLogId, this.userService);
    }
    createRequestTextTender(description, detail) {
        let out = description;
        for (const itemDetail of detail.Items.Listado) {
            if (itemDetail.Descripcion) {
                out = out + ' ' + itemDetail.Descripcion;
            }
            if (itemDetail.Categoria) {
                out = out + ' ' + itemDetail.Categoria;
            }
        }
        return out;
    }
    evalStateTender(detail) {
        return detail.Estado === 'Publicada' || detail.Estado === 'Desierta' || detail.Estado === 'Adjudicada';
    }
    async findSubdivision(listCities, detail, listSubdivisionDB) {
        let subdivisionId = null;
        let searchCity = detail.Comprador && detail.Comprador.ComunaUnidad;
        for (const city of listCities) {
            if (searchCity && this.normalizeString(searchCity.trim()) === this.normalizeString(city.name.trim())) {
                subdivisionId = city.subidivisionId;
                break;
            }
        }
        if (subdivisionId === null) {
            searchCity = detail.Comprador && detail.Comprador.RegionUnidad;
            for (const subdivision of listSubdivisionDB) {
                if (searchCity && this.normalizeString(searchCity.trim()) === this.normalizeString(subdivision.name.trim())) {
                    subdivisionId = subdivision.id;
                    break;
                }
            }
        }
        this.LOGGER.log(`findCity - subdivisionId: ${subdivisionId} - city: ${searchCity}`);
        return subdivisionId;
    }
    normalizeString(str) {
        return str
            .normalize("NFD")
            .replace(/[\u0300-\u036f]/g, "")
            .toLowerCase();
    }
    async getTenderByCode(code, userId) {
        const tender = await this.tenderRepository.findByCode(code);
        if (tender) {
            tender.minimalDetailCategory = tender.details.Items.Listado.map(item => item.NombreProducto);
            tender.labelAmount = util_1.TenderUtil.convertToMillions(tender.details.MontoEstimado || 0);
            tender.typeOfMoney = tender.details.Moneda;
            tender.labelLastUpdated = util_1.TenderUtil.calculateTime(tender.createdAt, tender.updatedAt);
            if (userId) {
                this.LOGGER.log(`SAVE INTO HISTORY_TENDER - code: ${code}, userId: ${userId} isFavorite: false`);
                this.userHistoryTenderService.saveHistoryTender(userId, tender.id);
            }
        }
        return tender;
    }
    async addTenderByCodeToCompany(code, companyId) {
        this.LOGGER.log(`addTenderByCodeToCompany - code: ${code}, companyId: ${companyId}`);
        const tenderMatch = await this.tenderRepository.findByCode(code);
        if (!tenderMatch) {
            this.LOGGER.warn(`addTenderByCodeToCompany - Tender not found for code: ${code}`);
            return 'Licitación no encontrada';
        }
        const company = await this.companyService.findById(companyId);
        if (!company) {
            this.LOGGER.warn(`addTenderByCodeToCompany - Company not found for companyId: ${companyId}`);
            return 'Empresa no encontrada';
        }
        const usersCompany = await this.userCompanyTenderRepository.getUsersIdsByCompanyId(companyId);
        const notificationsArray = [];
        for (const userId of usersCompany) {
            this.LOGGER.log(`addTenderByCodeToCompany - userId: ${userId} - code: ${code}`);
            this.userCompanyTenderRepository.save(userId, companyId, tenderMatch.id, `Licitación agregada por tu administrador.`, '');
            notificationsArray.push({
                userId: userId,
                title: `Coincidencias por palabras claves`,
                defaultMessage: `Creemos que esta licitación puede ser de tu interés`,
                active: true,
                monthFilterTender: null,
                amountWords: 0,
                amountGeo: 0
            });
        }
        notificationsArray.length > 0 && await this.notificationRecordService.saveAll(notificationsArray);
        return 'estado';
    }
    async generateInfoDashboard(user, companyId) {
        let output = new domain_1.DashboardTO();
        let listDetail = [];
        let amount = 0;
        this.userService.updateLastLogin(user.id);
        const company = await this.companyService.findById(companyId);
        const listSubdivisionIds = await this.companyService.getSubdivisionsByCompanyId(companyId);
        let amountFavorites = 0;
        let countFavorites = 0;
        if (company) {
            const tenderListByCompany = await this.userCompanyTenderRepository.findTenderByUserCompanyId(user.id, company.id);
            amount += tenderListByCompany.length;
            tenderListByCompany.forEach((tender) => {
                countFavorites = tender.isFavorite ? countFavorites + 1 : countFavorites;
                amountFavorites = tender.isFavorite ? amountFavorites + (tender.details.MontoEstimado || 0) : amountFavorites;
                if (!tender.isFavorite) {
                    const existingDetail = listDetail.find(detail => detail.description === tender.source);
                    if (existingDetail) {
                        existingDetail.amountPerSubdivision += tender.details.MontoEstimado || 0;
                        existingDetail.labelAmount = `${existingDetail.amountPerSubdivision} (${++existingDetail.count} coincidencias)`;
                    }
                    else {
                        listDetail.push({
                            description: tender.source,
                            amountPerSubdivision: tender.details.MontoEstimado || 0,
                            labelAmount: `${tender.details.MontoEstimado || 0} (1 coincidencia)`,
                            count: 1,
                        });
                    }
                }
            });
            if (countFavorites > 0) {
                listDetail.push({
                    description: 'Mis favoritos',
                    amountPerSubdivision: amountFavorites,
                    labelAmount: `${countFavorites} ${countFavorites == 1 ? 'en seguimiento' : 'en seguimiento'}`,
                });
            }
        }
        output.userAmount = await this.userCompanyService.countUserByCompany(companyId);
        output.tenderTotalAmount = await this.countActiveTenders();
        output.newTenderAmount = (amount - countFavorites < 0) ? 0 : amount - countFavorites;
        output.listDetails = listDetail.map((detail) => {
            if (detail.description === 'Mis favoritos') {
                return detail;
            }
            return {
                description: detail.description,
                amountPerSubdivision: detail.amountPerSubdivision,
                labelAmount: util_1.TenderUtil.convertToMillions(detail.amountPerSubdivision) + ` (${detail.count} ${detail.count == 1 ? 'coincidencia' : 'coincidencias'})`,
                dateFilterTender: util_1.TenderUtil.evalMonth(detail.description),
            };
        });
        const resultTotals = await this.tenderRepository.getTotalAmountAgileTenders(user.id, companyId, listSubdivisionIds.map(sub => sub.id));
        const dashboardAgile = new domain_1.AgileDashboardTO();
        dashboardAgile.agileTotalAmount = resultTotals.totalMoney;
        dashboardAgile.agileSubdivisionAmount = resultTotals.totalSubdivision;
        dashboardAgile.agileKeywordAmount = resultTotals.agileKeywordAmount;
        dashboardAgile.agileFavoriteAmount = resultTotals.favoriteMoney;
        output.agileTendersDetail = dashboardAgile;
        return output;
    }
    async getPaginatedTenders(userId, companyId, page, pageSize, searchType, filterLabel) {
        this.LOGGER.log(`GET PAGINATED TENDERS - userId: ${userId}, companyId: ${companyId}, page: ${page}, pageSize: ${pageSize}, searchType: ${searchType}, filterLabel: ${filterLabel}`);
        return (await this.userCompanyTenderRepository.getPaginatedTenders(userId, companyId, page, pageSize, searchType, filterLabel)).map((tender) => {
            tender.labelAmount = util_1.TenderUtil.convertToMillions(tender.details.MontoEstimado ? tender.details.MontoEstimado : 0);
            tender.typeOfMoney = tender.labelAmount === '0' ? `${tender.details.Moneda} - ${tender.details.Tipo}` : tender.details.Moneda;
            tender.labelLastUpdated = util_1.TenderUtil.calculateTime(tender.createdAt, tender.updatedAt);
            const closeTender = util_1.TenderUtil.calculateTimeFromDateString(tender.details.Fechas.FechaCierre);
            const dateInfo = closeTender.length > 0 ? `Fecha de cierre: ${tender.details.Fechas.FechaCierre?.substring(0, 16).replace('T', ' ')} ${closeTender === 'Finalizado' ? '' : '\n (' + closeTender}) ` : 'Fecha de cierre no informada';
            const publishDate = util_1.TenderUtil.calculateTimeFromDateString(tender.details.Fechas.FechaPublicacion);
            const datePublishInfo = publishDate.length > 0 ? `\n Fecha de publicación: ${tender.details.Fechas.FechaPublicacion?.substring(0, 16).replace('T', ' ')}` : 'Fecha de publicación no informada';
            tender.labelCloseTender = dateInfo + datePublishInfo + ' \n Estado: ' + tender.details.Estado;
            return tender;
        });
    }
    async getPaginatedHistoryTenders(userId, page, pageSize) {
        const resultPaginated = await this.userCompanyTenderRepository.getPaginatedHistoryTenders(userId, page, pageSize);
        const detailsTender = await this.tenderRepository.findInfohistoryTender(resultPaginated.map(tender => tender.id));
        this.LOGGER.log('size resultPaginated: ' + resultPaginated.length + ' - detailsTender: ' + detailsTender.length);
        return resultPaginated.map((tender) => {
            if (!tender.isErrased) {
                const detailTender = detailsTender.find(detail => detail.tenderId === tender.id);
                if (detailTender) {
                    tender.code = detailTender.code;
                    tender.name = `${detailTender.code} - ${detailTender.details.Nombre.toUpperCase() || ''}`;
                    tender.description = detailTender.details.Descripcion || '';
                    tender.labelAmount = util_1.TenderUtil.convertToMillions(detailTender.details.MontoEstimado || 0);
                    tender.typeOfMoney = tender.labelAmount === '0' ? `${detailTender.details.Moneda} - ${detailTender.details.Tipo}` : detailTender.details.Moneda;
                    tender.labelLastUpdated = util_1.TenderUtil.calculateTime(detailTender.createdAt, detailTender.updatedAt);
                    const closeTender = util_1.TenderUtil.calculateTimeFromDateString(detailTender.details.Fechas.FechaCierre);
                    const dateInfo = closeTender.length > 0 ? `Fecha de cierre: ${detailTender.details.Fechas.FechaCierre?.substring(0, 16).replace('T', ' ')} ${closeTender === 'Finalizado' ? '' : '\n (' + closeTender}) ` : 'Fecha de cierre no informada';
                    const publishDate = util_1.TenderUtil.calculateTimeFromDateString(detailTender.details.Fechas.FechaPublicacion);
                    const datePublishInfo = publishDate.length > 0 ? `\n Fecha de publicación: ${detailTender.details.Fechas.FechaPublicacion?.substring(0, 16).replace('T', ' ')}` : 'Fecha de publicación no informada';
                    tender.labelCloseTender = dateInfo + datePublishInfo + ' \n Estado: ' + detailTender.details.Estado;
                }
            }
            return tender;
        });
    }
    evalResultsMatch(tenderId, findMatchTopics, findMatchWords, findMatchCoarseTopic) {
        const listWithMatch = [];
        findMatchTopics.forEach((result) => {
            if (result.matches.length > 0) {
                listWithMatch.push(result.item.toLowerCase());
            }
        });
        return [...new Set(listWithMatch)];
    }
    getWordsFromMetadata(metadata) {
        let output = [];
        metadata.forEach((word) => {
            if (word.partOfSpeech === 'NN') {
                output.push(word.stem);
            }
        });
        return output;
    }
    getListOfWordsMetada(json) {
        let wordsList = [];
        if (json.words) {
            wordsList = json.words.filter((word) => word.partOfSpeech === 'NOUN' || word.partOfSpeech === 'ADJ');
        }
        let topicsList = [];
        if (json.topics) {
            topicsList = json.topics.filter((topic) => topic.score > 0.6);
        }
        let coarseTopicsList = [];
        if (json.coarseTopics) {
            coarseTopicsList = json.coarseTopics.filter((coarseTopic) => coarseTopic.score > 1);
        }
        return {
            wordsList,
            topicsList,
            coarseTopicsList
        };
    }
    async fetchRazorMetadata(textToEval, secondKey = false) {
        this.LOGGER.log(`Fetching metadata for text: ${textToEval}`);
        const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
        for (let attempt = 1; attempt <= this.maxTextRetries; attempt++) {
            try {
                const formData = new URLSearchParams();
                formData.append('text', textToEval);
                formData.append('extractors', 'entities,topics,entailments');
                const response = await (0, rxjs_1.firstValueFrom)(this.httpService.post(this.textApiUrl, formData, {
                    headers: {
                        'x-textrazor-key': secondKey ? this.textApiSecondKey : this.textApiKey,
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                }));
                return response.data;
            }
            catch (error) {
                if (attempt === Number(this.maxTextRetries)) {
                    this.LOGGER.debug(`Failed to fetch tender details for args: ${JSON.stringify(textToEval)}`);
                    throw error;
                }
                this.LOGGER.debug(`Attempt ${attempt} failed. Retrying in ${attempt * 5}ms...`);
                await delay(attempt * 5);
            }
        }
    }
    async recalculteTender(applicationLogId) {
        this.LOGGER.log('recalculateTender - START');
        const companyIds = await this.companyService.getCompanyIdsToRecalculateTender();
        this.LOGGER.log(`recalculateTender - companyIds size: ${companyIds.length}`);
        let messageTxt = `Recalculating tenders for ${companyIds.length} companies`;
        await this.applicationLogService.updateState(applicationLogId, 8, messageTxt);
        for (const companyId of companyIds) {
            this.LOGGER.log(`recalculateTender - applicationLogId: ${applicationLogId} - errase actual tenders - companyId: ${companyId}`);
            messageTxt = messageTxt.concat('. Errase tender to companyId: ' + companyId);
            this.userCompanyTenderRepository.erraseJoinCompanyTender(companyId);
            this.LOGGER.log(`recalculateTender - applicationLogId: ${applicationLogId} - search new tenders dashboard - companyId: ${companyId}`);
            const activeUserIds = await this.userCompanyService.getUserIdsWithActiveCompany();
            messageTxt = messageTxt.concat('. Loading new tenders to companyId: ' + companyId + ' and users: ' + activeUserIds.length);
            for (const userId of activeUserIds) {
                this.LOGGER.log(`recalculateTender - applicationLogId: ${applicationLogId} - create dashboard for userId: ${userId} companyId: ${companyId}`);
                this.createDashboardCompany(companyId, [userId]);
            }
            this.companyService.updateCheckTenders(companyId, true);
        }
        return messageTxt;
    }
};
exports.TenderServiceImpl = TenderServiceImpl;
exports.TenderServiceImpl = TenderServiceImpl = TenderServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('TenderRepository')),
    __param(1, (0, common_1.Inject)('CompanyService')),
    __param(2, (0, common_1.Inject)('CompanyKeywordService')),
    __param(3, (0, common_1.Inject)('HistoryTenderService')),
    __param(4, (0, common_1.Inject)('MatchWordsService')),
    __param(5, (0, common_1.Inject)('UserCompanyTenderService')),
    __param(6, (0, common_1.Inject)('UserCompanyAgileTenderService')),
    __param(7, (0, common_1.Inject)('NotificationRecordService')),
    __param(8, (0, common_1.Inject)('GeoService')),
    __param(11, (0, common_1.Inject)('FirebaseService')),
    __param(12, (0, common_1.Inject)('KeywordService')),
    __param(13, (0, common_1.Inject)('UserService')),
    __param(14, (0, common_1.Inject)('ApplicationLogService')),
    __param(15, (0, common_1.Inject)('UserCompanyService')),
    __param(16, (0, common_1.Inject)('UserRequestService')),
    __param(17, (0, common_1.Inject)('FwkCacheService')),
    __param(18, (0, common_1.Inject)('TenderFetcherService')),
    __param(19, (0, common_1.Inject)('TenderKeywordCategoryService')),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object, Object, Object, Object, Object, config_1.ConfigService,
        axios_1.HttpService, Object, Object, Object, Object, Object, Object, Object, Object, Object])
], TenderServiceImpl);
//# sourceMappingURL=tender-service-impl.js.map