import { UserRequestService } from 'src/framework';
import { AgileTenderFullInfoTO } from 'src/licitaapp/application';
import { UserCompanyAgileTenderRepository } from 'src/licitaapp/application/repository/user-company-agile-tender-repository/user-company-agile-tender-repository.interface';
import { UserCompanyAgileTenderService } from 'src/licitaapp/application/service/user-company-agile-tender-service/user-company-agile-tender-service.interface';
import { AgileTender } from 'src/licitaapp/domain';
export declare class UserCompanyAgileTenderServiceImpl implements UserCompanyAgileTenderService {
    private readonly userCompanyAgileTenderRepository;
    private readonly LOGGER;
    constructor(userCompanyAgileTenderRepository: UserCompanyAgileTenderRepository);
    findTenderByUserCompanyId(userId: number, companyId: number): Promise<AgileTender[]>;
    countActiveTendersCompany(companyId: number): Promise<number>;
    getFavoriteList(userId: number): Promise<number[]>;
    erraseUserCompanyAgileTender(tenderAgileIds: number[]): Promise<void>;
    saveAll(userId: number, companyId: number, tenderIds: number[], isFavorite: boolean, agileCode?: string, userRequestService?: UserRequestService): Promise<boolean>;
    getPaginatedAgileTenders(userId: number, companyId: number, page: number, pageSize: number, isFavorite: boolean): Promise<AgileTenderFullInfoTO[]>;
}
