"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserCompanyAgileTenderServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCompanyAgileTenderServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
let UserCompanyAgileTenderServiceImpl = UserCompanyAgileTenderServiceImpl_1 = class UserCompanyAgileTenderServiceImpl {
    constructor(userCompanyAgileTenderRepository) {
        this.userCompanyAgileTenderRepository = userCompanyAgileTenderRepository;
        this.LOGGER = new framework_1.PrimeLogger(UserCompanyAgileTenderServiceImpl_1.name);
    }
    findTenderByUserCompanyId(userId, companyId) {
        this.LOGGER.log(`findTenderByUserCompanyId - userId: ${userId}, companyId: ${companyId}`);
        return this.userCompanyAgileTenderRepository.findTenderByUserCompanyId(userId, companyId);
    }
    countActiveTendersCompany(companyId) {
        this.LOGGER.log(`countActiveTendersCompany - companyId: ${companyId}`);
        return this.userCompanyAgileTenderRepository.countActiveTendersCompany(companyId);
    }
    getFavoriteList(userId) {
        this.LOGGER.log(`getFavoriteList - userId: ${userId}`);
        return this.userCompanyAgileTenderRepository.getFavoriteList(userId);
    }
    erraseUserCompanyAgileTender(tenderAgileIds) {
        this.LOGGER.log(`erraseUserCompanyAgileTender - tenderAgileIds: ${tenderAgileIds}`);
        return this.userCompanyAgileTenderRepository.erraseUserCompanyAgileTender(tenderAgileIds);
    }
    async saveAll(userId, companyId, tenderIds, isFavorite, agileCode, userRequestService) {
        this.LOGGER.log(`saveAll - userId: ${userId}, companyId: ${companyId}, tenderIds: ${tenderIds} isFavorite: ${isFavorite}`);
        if (isFavorite && userRequestService) {
            this.LOGGER.log(`Creating user request for favorite agile tender - userId: ${userId}, companyId: ${companyId}, tenderIds: ${tenderIds}`);
            const dataSend = new framework_1.InsertUserRequest();
            dataSend.companyId = companyId;
            dataSend.title = `Se ha marcado una compra ágil`;
            dataSend.description = `El usuario ha marcado como favorito la licitación ágil: ${agileCode}`;
            await userRequestService.createUserRequest(userId, dataSend);
        }
        return this.userCompanyAgileTenderRepository.saveAll(userId, companyId, tenderIds, isFavorite);
    }
    getPaginatedAgileTenders(userId, companyId, page, pageSize, isFavorite) {
        this.LOGGER.log(`getPaginatedAgileTenders - userId: ${userId}, companyId: ${companyId}, page: ${page}, pageSize: ${pageSize}, isFavorite: ${isFavorite}`);
        return this.userCompanyAgileTenderRepository.getPaginatedAgileTenders(userId, companyId, page, pageSize, isFavorite);
    }
};
exports.UserCompanyAgileTenderServiceImpl = UserCompanyAgileTenderServiceImpl;
exports.UserCompanyAgileTenderServiceImpl = UserCompanyAgileTenderServiceImpl = UserCompanyAgileTenderServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('UserCompanyAgileTenderRepository')),
    __metadata("design:paramtypes", [Object])
], UserCompanyAgileTenderServiceImpl);
//# sourceMappingURL=user-company-agile-tender-service-impl.js.map