import { UserCompanyTenderRepository } from 'src/licitaapp/application/repository/user-company-tender-repository/user-company-tender-repository.interface';
import { UserCompanyTenderService } from 'src/licitaapp/application/service/user-company-tender-service/user-company-tender-service.interface';
import { HistoryTenderDetail, Tender, TenderTO } from 'src/licitaapp/domain';
export declare class UserCompanyTenderServiceImpl implements UserCompanyTenderService {
    private readonly userCompanyTenderRepository;
    private readonly LOGGER;
    constructor(userCompanyTenderRepository: UserCompanyTenderRepository);
    erraseUserCompanyTender(tenderIds: TenderTO[]): Promise<void>;
    saveAll(userId: number, companyId: number, tenderIds: number[], source: string): Promise<boolean>;
    updateFavoriteUserCompanyTender(userId: number, companyId: number, tenderId: number, isFavorite: boolean): Promise<void>;
    save(userId: number, companyId: number, tenderId: number, source: string, matchResult: string): Promise<boolean>;
    findAllUserIdWithTenders(): Promise<number[]>;
    findTenderByUserCompanyId(userId: number, companyId: number): Promise<Tender[]>;
    getPaginatedTenders(userId: number, companyId: number, page: number, pageSize: number, searchType: string, filterLabel: string): Promise<Tender[]>;
    getHistoryTendersFavorite(userId: number, dateRequest: Date): Promise<Tender[]>;
    getPaginatedHistoryTenders(userId: number, page: number, pageSize: number): Promise<HistoryTenderDetail[]>;
    logicalRemoveCompanyTenderUser(userId: number, companyId: number, tenderId: number): Promise<void>;
    erraseJoinCompanyTender(companyId: number): Promise<void>;
    countActiveTendersCompany(companyId: number): Promise<number>;
    getUsersIdsByCompanyId(companyId: number): Promise<number[]>;
}
