"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const swagger_1 = require("@nestjs/swagger");
const app_module_1 = require("./app.module");
const framework_1 = require("./framework");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    app.useGlobalFilters(new framework_1.HttpExceptionFilter());
    app.useLogger(new framework_1.AppExceptionLogger('LicitaApp'));
    const config = new swagger_1.DocumentBuilder()
        .setTitle('AMK API')
        .setDescription('Endpoints aplicaciónn para consumo de servicios de Mercado Publico y AMK')
        .setVersion('1.0')
        .addBearerAuth()
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('api', app, document);
    const port = process.env.PORT || 3000;
    await app.listen(port);
    console.log(`Application is running on: ${await app.getUrl()}`);
}
bootstrap();
//# sourceMappingURL=main.js.map