import { InsertUserCampaign, UpdateUserCampaign, UserCampaign } from "src/framework/domain";

export interface UserCampaignsRepository {
    create(data: InsertUserCampaign): Promise<UserCampaign | null | undefined>;
    update(data: UpdateUserCampaign): Promise<string>;
    getActiveCampaigns(): Promise<UserCampaign[]>;
    getPagination(page: number, pageSize: number, filter?: string): Promise<UserCampaign[]>;
    logicalRemove(campaignId: number): Promise<void>;
}
