import * as admin from 'firebase-admin';
import { BatchResponse } from 'firebase-admin/lib/messaging/messaging-api';
import { UserService } from '../user-service/user-service.interface';
type NotificationData = { [key: string]: string };

export interface FirebaseService {
  verifyIdToken(idToken: string): Promise<admin.auth.DecodedIdToken>;
  sendPushNotification(tokens: string[], title: string, body: string, data?: NotificationData): Promise<BatchResponse | undefined>;
  deleteUserFromFirebase(uid: string): Promise<void>;
  sendDailyEmailSumary(applicationLogId: number): Promise<string>;
  /**
   * Envia un consolidado via email a los administradores del sistema.
   * Usa canal EMAIL
   * @param applicationLogId -° Tracking de DB.
   * @param userService -° Servicio de usuario para obtener datos del usuario.
   * @returns Mensaje de resultado.
   */
  sendEmailSumaryToAdmin(applicationLogId: number, userService: UserService): Promise<string>;
  groupNotifications(userId: number): Promise<void>;
  /**
   * Envia todas las notificaciones a los usuarios que tengan notificaciones pendientes en la tabla notification_record.
   */
  sendAllNotificationsRecords(): Promise<void>;
  notifyToAdminUsers(countActiveRequests: number): Promise<void>;
  sendNewsEmail(email: string, dayOfweekLabel: string, amountWordsTender?: number, amountGeoTenders?: number): Promise<void>;
}
