import { ApiProperty } from '@nestjs/swagger';

class LoginOutTO {
  @ApiProperty({
    description: 'Token',
  })
  public token: string;
  @ApiProperty({
    description: 'Full name',
    example: 'John Doe',
  })
  public fullName: string;

  @ApiProperty({
    description: 'User cell phone',
    example: '1234567890',
    required: false,
    type: String,
  })
  cellPhone?: string | null | undefined;
  @ApiProperty({
    description: 'Profile of the user',
    required: true,
    type: String,
  })
  roles: string;
  @ApiProperty({
    description: 'Last update date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
    type: Date,
  })
  aggrementDate?: Date | null;

  @ApiProperty({
    description: 'Latest version iOS',
    example: '1.0.0+x',
    type: String,
    required: false,
  })
  latestVersionIOS?: string | null;
  @ApiProperty({
    description: 'Latest version Android',
    example: '1.0.0+x',
    type: String,
    required: false,
  })
  latestVersionAndroid?: string | null;
  
  constructor(token: string, fullName: string, roles: string, aggrementDate?: Date | null, cellPhone?: string | null | undefined) {
    this.token = token;
    this.fullName = fullName;
    this.aggrementDate = aggrementDate;
    this.cellPhone = cellPhone;
    this.roles = roles;
  }
}

export { LoginOutTO };
