import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';

class RequestTenderTO {
    @ApiProperty({
        description: 'UserRequest id',
        example: 1,
        required: true,
    })
    id: number;

    @ApiProperty({
        description: 'Company Social reason',
        example: 'Venta de peras',
        required: true,
    })
    companySocialreason: string;

    @ApiProperty({
        description: 'Company DNI',
        example: '12345678-1',
        required: true,
    })
    companyDni: string;

    @ApiProperty({
        description: 'Tender CODE',
        example: 'XXX-kkk-08',
        required: true,
    })
    tenderCode: string;

    @ApiProperty({
        description: 'User request',
        example: 'Yuri Perez',
        required: true,
    })
    userName: string;

    @ApiProperty({
        description: 'State request type',
        example: 'Abierto',
        required: true,
    })
    stateRequestType: string;

    @ApiProperty({
        description: 'Phone',
        example: '4564546',
        required: true,
      })
    phoneNumber: string;

    @ApiProperty({
        description: 'email',
        example: 'yperez@previred.com',
        required: true,
      })
    email: string;

    @ApiProperty({
        description: 'Creation date',
        example: '1991-01-01T00:00:00.000Z',
        required: true,
    })
    createdAt?: Date | null;

    @ApiProperty({
        description: 'Last update date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    })
    updatedAt?: Date | null;

    @ApiProperty({
        description: 'Description',
        example: 'This is a description of the request tender',
        required: false,
    })
    description?: string;

    constructor(
        id: number,
        companySocialreason: string,
        companyDni: string,
        tenderCode: string,
        userName: string,
        stateRequestType: string,
        phoneNumber: string,
        email: string,
        createdAt?: Date | null,
        updatedAt?: Date | null
    ){
        this.id = id;
        this.companySocialreason = companySocialreason;
        this.companyDni = companyDni;
        this.tenderCode = tenderCode;
        this.userName = userName;
        this.phoneNumber = phoneNumber;
        this.email = email;
        this.stateRequestType = stateRequestType;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
}

export { RequestTenderTO };