import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';

class UserCampaign {
  @ApiProperty({
    description: 'User campaign id',
    example: 1,
    type: Number,
    required: true,
  })
  id: number;

  @ApiProperty({
    description: 'User campaign description',
    example: 'Description of the user campaign',
    type: String,
    required: true,
  })
  description: string;

  @ApiProperty({
    description: 'User campaign default message',
    example: 'Oil Change Reminder',
    required: true,
  })
  defaultMessage: string;

  @ApiProperty({
    description: 'User campaign title',
    example: 'Oil Change Reminder',
    required: true,
  })
  title: string;

  @ApiProperty({
    description: 'User campaign day of the week',
    example: '1-2-3-4', // 0 = Sunday, 1 = Monday, ..., 6 = Saturday
    required: true,
    type: String,
  })
  dayOfWeek: string;

  @ApiProperty({
    description: 'User campaign title',
    example: 12,
    required: true,
    type: Number,
  })
  defHour: number | null | undefined;

  @ApiProperty({
    description: 'User campaign title',
    example: 50, 
    type: Number,  
    required: true, 
  })
  defMinute: number | null | undefined;

}

class InsertUserCampaign extends OmitType(UserCampaign, ['id']) {}

class UpdateUserCampaign extends PartialType(UserCampaign) {}

export { InsertUserCampaign, UpdateUserCampaign, UserCampaign };
