import { createParamDecorator, ExecutionContext } from '@nestjs/common';
import { Request } from 'express';

/**
 * Custom decorator to extract the access token from the request.
 *
 * @param data - Custom data passed to the decorator (not used here).
 * @param ctx - The execution context, which provides access to the request.
 * @returns The access token from the request.
 */
export const AccessToken = createParamDecorator(
  (data: unknown, ctx: ExecutionContext) => {
    const request = ctx.switchToHttp().getRequest<Request>();
    return request.accessToken;
  },
);
