import { SetMetadata } from '@nestjs/common';

const IS_PUBLIC_KEY = 'isPublic';

/**
 * Custom decorator to mark a route as public (no authentication required).
 *
 * @returns A decorator function that sets metadata indicating the route is public.
 */
const Public = () => SetMetadata(IS_PUBLIC_KEY, true);

export { IS_PUBLIC_KEY, Public };
