import { HttpException, HttpStatus } from '@nestjs/common';

enum ExceptionType {
  BUSINESS = 'BUSINESS',
  INTERNAL = 'INTERNAL',
}

class PrimeException extends HttpException {
  public readonly message: string;
  public readonly type: ExceptionType;
  constructor(
    message: string,
    status: HttpStatus = HttpStatus.INTERNAL_SERVER_ERROR,
    type: ExceptionType = ExceptionType.BUSINESS,
  ) {
    super({ status, message, type }, status);
    this.message = message;
    this.type = type;
  }
}

export { PrimeException, ExceptionType };
