import { Logger as NestLogger } from '@nestjs/common';
import { Logger } from 'drizzle-orm/logger';

export class DrizzleLogger implements Logger {
  constructor(
    private readonly shouldLog = false,
    private readonly paramPrefix?: string,
  ) {}

  logQuery(query: string, params: unknown[]): void {
    if (!this.shouldLog) {
      return;
    }
    if (this.paramPrefix) {
      query = query.replace(/\$(\d+|\w+)/g, (param) => {
        const paramName = param.replace(/\$/, '');
        return `${this.paramPrefix}${paramName}`;
      });
    }

    NestLogger.debug(
      `Query: ${query}; with params: ${JSON.stringify(params)}`,
      'DrizzleModule',
    );
  }
}
