import { Module } from '@nestjs/common';
import { DrizzleModule } from '../../drizzle';
import { NotificationRecordServiceImpl } from '../../service/notification-record-service-impl/notification-record-service-impl';
import { NotificationRecordRepositoryImpl } from '../../repository/notification-record-repository-impl/notification-record-repository-impl';

@Module({
    imports: [DrizzleModule],
    providers: [
        {
            provide: 'NotificationRecordService',
            useClass: NotificationRecordServiceImpl,
        },
        {
            provide: 'NotificationRecordRepository',
            useClass: NotificationRecordRepositoryImpl,
        },
    ],
    exports: [
        'NotificationRecordRepository',
        'NotificationRecordService',
    ],
})
export class NotificationRecordModule {}
