import { Module } from '@nestjs/common';
import { Role } from 'src/framework/domain';
import { DrizzleModule } from 'src/framework/infrastructure/drizzle';
import { RoleRepositoryImpl } from 'src/framework/infrastructure/repository/role-repository-impl/role-repository-impl';
import { RolServiceImplService } from 'src/framework/infrastructure/service/role-service-impl/role-service-impl.service';
import { UserRoleModule } from '../user-role/user-role.module';

@Module({
    imports: [DrizzleModule],
    providers: [
        {
            provide: 'RoleRepository',
            useClass: RoleRepositoryImpl,
        },
        {
            provide: 'RoleService',
            useClass: RolServiceImplService,
        },
    ],
    exports: [
        'RoleRepository',
        'RoleService',
    ],
})
export class RoleModule {

}
