import { Module } from '@nestjs/common';
import { DrizzleModule } from '../../drizzle';
import { UserDeviceRepositoryImpl } from '../../repository';
import { UserDeviceServiceImpl } from '../../service';
import { UserRoleModule } from '../user-role/user-role.module';

@Module({
    imports: [DrizzleModule, UserRoleModule],
    providers: [
        {
            provide: 'UserDeviceRepository',
            useClass: UserDeviceRepositoryImpl,
        },
        {
            provide: 'UserDeviceService',
            useClass: UserDeviceServiceImpl,
        },
    ],
    exports: [
        'UserDeviceRepository',
        'UserDeviceService',
    ],
})
export class UserDeviceModule {}
