import { Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework/infrastructure/drizzle';
import { UserRequestController } from '../../controllers';
import { UserRequestServiceImpl } from '../../service';
import {
  UserRequestRepositoryImpl,
} from '../../repository';
import { TypeMasterModule } from '../type-master/type-master.module';
import { UserModule } from 'src/licitaapp/infrastructure/module/user/user.module';
import { CompanyModule } from 'src/licitaapp';
import { NotificationModule } from '../notification/notification.module';
import { NotificationRecordModule } from '../notification-record/notification-record.module';
import { UserRoleModule } from '../user-role/user-role.module';

@Module({
  imports: [DrizzleModule, TypeMasterModule, UserModule, UserRoleModule, CompanyModule, NotificationModule,NotificationRecordModule],
  controllers: [UserRequestController],
  providers: [
    {
      provide: 'UserRequestService',
      useClass: UserRequestServiceImpl,
    },
    {
      provide: 'UserRequestRepository',
      useClass: UserRequestRepositoryImpl,
    }
  ],
  exports: [
    'UserRequestService',
    'UserRequestRepository'
  ],
})
export class UserRequestModule {

}
