import { Inject, Injectable } from '@nestjs/common';
import { AccessService, UserService, UserRoleService, RoleService } from 'src/framework/application';
import { RecordTO } from 'src/framework/domain';
import { PrimeLogger } from '../../definition';


@Injectable()
export class AccessImplService implements AccessService {
    private readonly LOGGER = new PrimeLogger(AccessImplService.name);

    constructor(
        @Inject('UserService')  private readonly userService: UserService,
        @Inject('UserRoleService') private readonly userRoleService: UserRoleService,
        @Inject('RoleService') private readonly roleService: RoleService,
    ) {}

    async registerUserByRole(recordTO: RecordTO): Promise<boolean> {
        this.LOGGER.log(`registerUserByRole - recordTO: ${JSON.stringify(recordTO)}`);
        const user = await this.userService.createUser(recordTO.user);
        const role = await this.roleService.getRoleByKey(
          recordTO.role.shortName,
        );
        return await this.userRoleService.createUserRole(user.id, role.id);
    }

}
